/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumberGauge;

public class DoubleGauge
extends NumberGauge {
    private final AtomicDouble number = (AtomicDouble)this.getValue();

    public DoubleGauge(MonitorConfig config) {
        super(config, (Number)new AtomicDouble(0.0));
    }

    public void set(Double n) {
        this.number.set(n.doubleValue());
    }

    public AtomicDouble getNumber() {
        return this.number;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleGauge that = (DoubleGauge)o;
        return this.getConfig().equals(that.getConfig()) && this.number.get() == that.number.get();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.number.get(), this.getConfig()});
    }
}

