/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.plugin.activerecord.generator.TypeMapping;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;

public class MetaBuilder {
    protected DataSource dataSource;
    protected Dialect dialect = new MysqlDialect();
    protected Set<String> excludedTables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected Connection conn = null;
    protected DatabaseMetaData dbMeta = null;
    protected String[] removedTableNamePrefixes = null;
    protected TypeMapping typeMapping = new TypeMapping();

    public MetaBuilder(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        this.dataSource = dataSource;
    }

    public void setDialect(Dialect dialect) {
        if (dialect != null) {
            this.dialect = dialect;
        }
    }

    public void addExcludedTable(String ... excludedTables) {
        if (excludedTables != null) {
            for (String table : excludedTables) {
                this.excludedTables.add(table);
            }
        }
    }

    public void setRemovedTableNamePrefixes(String ... removedTableNamePrefixes) {
        this.removedTableNamePrefixes = removedTableNamePrefixes;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        if (typeMapping != null) {
            this.typeMapping = typeMapping;
        }
    }

    public List<TableMeta> build() {
        System.out.println("Build TableMeta ...");
        try {
            this.conn = this.dataSource.getConnection();
            this.dbMeta = this.conn.getMetaData();
            ArrayList<TableMeta> ret = new ArrayList<TableMeta>();
            this.buildTableNames(ret);
            for (TableMeta tableMeta : ret) {
                this.buildPrimaryKey(tableMeta);
                this.buildColumnMetas(tableMeta);
            }
            ArrayList<TableMeta> arrayList = ret;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected boolean isSkipTable(String tableName) {
        return false;
    }

    protected String buildModelName(String tableName) {
        if (this.removedTableNamePrefixes != null) {
            for (String prefix : this.removedTableNamePrefixes) {
                if (!tableName.startsWith(prefix)) continue;
                tableName = tableName.replaceFirst(prefix, "");
                break;
            }
        }
        if (this.dialect instanceof OracleDialect) {
            tableName = tableName.toLowerCase();
        }
        return StrKit.firstCharToUpperCase(StrKit.toCamelCase(tableName));
    }

    protected String buildBaseModelName(String modelName) {
        return "Base" + modelName;
    }

    protected ResultSet getTablesResultSet() throws SQLException {
        String schemaPattern = this.dialect instanceof OracleDialect ? this.dbMeta.getUserName() : null;
        return this.dbMeta.getTables(this.conn.getCatalog(), schemaPattern, null, new String[]{"TABLE", "VIEW"});
    }

    protected void buildTableNames(List<TableMeta> ret) throws SQLException {
        ResultSet rs = this.getTablesResultSet();
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (this.excludedTables.contains(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            if (this.isSkipTable(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            TableMeta tableMeta = new TableMeta();
            tableMeta.name = tableName;
            tableMeta.remarks = rs.getString("REMARKS");
            tableMeta.modelName = this.buildModelName(tableName);
            tableMeta.baseModelName = this.buildBaseModelName(tableMeta.modelName);
            ret.add(tableMeta);
        }
        rs.close();
    }

    protected void buildPrimaryKey(TableMeta tableMeta) throws SQLException {
        ResultSet rs = this.dbMeta.getPrimaryKeys(this.conn.getCatalog(), null, tableMeta.name);
        String primaryKey = "";
        int index = 0;
        while (rs.next()) {
            if (index++ > 0) {
                primaryKey = primaryKey + ",";
            }
            primaryKey = primaryKey + rs.getString("COLUMN_NAME");
        }
        tableMeta.primaryKey = primaryKey;
        rs.close();
    }

    protected void buildColumnMetas(TableMeta tableMeta) throws SQLException {
        String sql = this.dialect.forTableBuilderDoBuild(tableMeta.name);
        Statement stm = this.conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            int type;
            ColumnMeta cm = new ColumnMeta();
            cm.name = rsmd.getColumnName(i);
            String colClassName = rsmd.getColumnClassName(i);
            String typeStr = this.typeMapping.getType(colClassName);
            cm.javaType = typeStr != null ? typeStr : ((type = rsmd.getColumnType(i)) == -2 || type == -3 || type == 2004 ? "byte[]" : (type == 2005 || type == 2011 ? "java.lang.String" : "java.lang.String"));
            cm.attrName = this.buildAttrName(cm.name);
            tableMeta.columnMetas.add(cm);
        }
        rs.close();
        stm.close();
    }

    protected String buildAttrName(String colName) {
        if (this.dialect instanceof OracleDialect) {
            colName = colName.toLowerCase();
        }
        return StrKit.toCamelCase(colName);
    }
}

