/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.JavaKeyword;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class BaseModelGenerator {
    protected String packageTemplate = "package %s;%n%n";
    protected String importTemplate = "import com.jfinal.plugin.activerecord.Model;%nimport com.jfinal.plugin.activerecord.IBean;%n%n";
    protected String classDefineTemplate = "/**%n * Generated by JFinal, do not modify this file.%n */%n@SuppressWarnings(\"serial\")%npublic abstract class %s<M extends %s<M>> extends Model<M> implements IBean {%n%n";
    protected String setterTemplate = "\tpublic void %s(%s %s) {%n\t\tset(\"%s\", %s);%n\t}%n%n";
    protected String getterTemplate = "\tpublic %s %s() {%n\t\treturn get(\"%s\");%n\t}%n%n";
    protected String baseModelPackageName;
    protected String baseModelOutputDir;
    protected JavaKeyword javaKeyword = new JavaKeyword();

    public BaseModelGenerator(String baseModelPackageName, String baseModelOutputDir) {
        if (StrKit.isBlank(baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank(baseModelOutputDir)) {
            throw new IllegalArgumentException("baseModelOutputDir can not be blank.");
        }
        this.baseModelPackageName = baseModelPackageName;
        this.baseModelOutputDir = baseModelOutputDir;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate base model ...");
        for (TableMeta tableMeta : tableMetas) {
            this.genBaseModelContent(tableMeta);
        }
        this.wirtToFile(tableMetas);
    }

    protected void genBaseModelContent(TableMeta tableMeta) {
        StringBuilder ret = new StringBuilder();
        this.genPackage(ret);
        this.genImport(ret);
        this.genClassDefine(tableMeta, ret);
        for (ColumnMeta columnMeta : tableMeta.columnMetas) {
            this.genSetMethodName(columnMeta, ret);
            this.genGetMethodName(columnMeta, ret);
        }
        ret.append(String.format("}%n", new Object[0]));
        tableMeta.baseModelContent = ret.toString();
    }

    protected void genPackage(StringBuilder ret) {
        ret.append(String.format(this.packageTemplate, this.baseModelPackageName));
    }

    protected void genImport(StringBuilder ret) {
        ret.append(String.format(this.importTemplate, new Object[0]));
    }

    protected void genClassDefine(TableMeta tableMeta, StringBuilder ret) {
        ret.append(String.format(this.classDefineTemplate, tableMeta.baseModelName, tableMeta.baseModelName));
    }

    protected void genSetMethodName(ColumnMeta columnMeta, StringBuilder ret) {
        String setterMethodName = "set" + StrKit.firstCharToUpperCase(columnMeta.attrName);
        String argName = this.javaKeyword.contains(columnMeta.attrName) ? "_" + columnMeta.attrName : columnMeta.attrName;
        String setter = String.format(this.setterTemplate, setterMethodName, columnMeta.javaType, argName, columnMeta.name, argName);
        ret.append(setter);
    }

    protected void genGetMethodName(ColumnMeta columnMeta, StringBuilder ret) {
        String getterMethodName = "get" + StrKit.firstCharToUpperCase(columnMeta.attrName);
        String getter = String.format(this.getterTemplate, columnMeta.javaType, getterMethodName, columnMeta.name);
        ret.append(getter);
    }

    protected void wirtToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.wirtToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wirtToFile(TableMeta tableMeta) throws IOException {
        File dir = new File(this.baseModelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = this.baseModelOutputDir + File.separator + tableMeta.baseModelName + ".java";
        FileWriter fw = new FileWriter(target);
        try {
            fw.write(tableMeta.baseModelContent);
        }
        finally {
            fw.close();
        }
    }
}

