/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.NullDataSource;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableBuilder;
import com.jfinal.plugin.activerecord.cache.EhCache;
import com.jfinal.plugin.activerecord.cache.ICache;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class ActiveRecordPlugin
implements IPlugin {
    private String configName = null;
    private DataSource dataSource = null;
    private IDataSourceProvider dataSourceProvider = null;
    private Integer transactionLevel = null;
    private ICache cache = null;
    private Boolean showSql = null;
    private Boolean devMode = null;
    private Dialect dialect = null;
    private IContainerFactory containerFactory = null;
    private Config config = null;
    private boolean isStarted = false;
    private List<Table> tableList = new ArrayList<Table>();

    public ActiveRecordPlugin(String configName, DataSource dataSource, int transactionLevel) {
        if (StrKit.isBlank(configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null");
        }
        this.configName = configName.trim();
        this.dataSource = dataSource;
        this.setTransactionLevel(transactionLevel);
    }

    public ActiveRecordPlugin(DataSource dataSource) {
        this("main", dataSource);
    }

    public ActiveRecordPlugin(String configName, DataSource dataSource) {
        this(configName, dataSource, 4);
    }

    public ActiveRecordPlugin(DataSource dataSource, int transactionLevel) {
        this("main", dataSource, transactionLevel);
    }

    public ActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider, int transactionLevel) {
        if (StrKit.isBlank(configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSourceProvider == null) {
            throw new IllegalArgumentException("dataSourceProvider can not be null");
        }
        this.configName = configName.trim();
        this.dataSourceProvider = dataSourceProvider;
        this.setTransactionLevel(transactionLevel);
    }

    public ActiveRecordPlugin(IDataSourceProvider dataSourceProvider) {
        this("main", dataSourceProvider);
    }

    public ActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider) {
        this(configName, dataSourceProvider, 4);
    }

    public ActiveRecordPlugin(IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this("main", dataSourceProvider, transactionLevel);
    }

    public ActiveRecordPlugin(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        this.config = config;
    }

    public ActiveRecordPlugin addMapping(String tableName, String primaryKey, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, primaryKey, modelClass));
        return this;
    }

    public ActiveRecordPlugin addMapping(String tableName, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, modelClass));
        return this;
    }

    public ActiveRecordPlugin setTransactionLevel(int transactionLevel) {
        int t = transactionLevel;
        if (t != 0 && t != 1 && t != 2 && t != 4 && t != 8) {
            throw new IllegalArgumentException("The transactionLevel only be 0, 1, 2, 4, 8");
        }
        this.transactionLevel = transactionLevel;
        return this;
    }

    public ActiveRecordPlugin setCache(ICache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        this.cache = cache;
        return this;
    }

    public ActiveRecordPlugin setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    public ActiveRecordPlugin setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public Boolean getDevMode() {
        return this.devMode;
    }

    public ActiveRecordPlugin setDialect(Dialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        this.dialect = dialect;
        return this;
    }

    public ActiveRecordPlugin setContainerFactory(IContainerFactory containerFactory) {
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        this.containerFactory = containerFactory;
        return this;
    }

    public void setPrimaryKey(String tableName, String primaryKey) {
        for (Table table : this.tableList) {
            if (!table.getName().equalsIgnoreCase(tableName.trim())) continue;
            table.setPrimaryKey(primaryKey);
        }
    }

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        if (this.configName == null) {
            this.configName = "main";
        }
        if (this.dataSource == null && this.dataSourceProvider != null) {
            this.dataSource = this.dataSourceProvider.getDataSource();
        }
        if (this.dataSource == null) {
            throw new RuntimeException("ActiveRecord start error: ActiveRecordPlugin need DataSource or DataSourceProvider");
        }
        if (this.config == null) {
            this.config = new Config(this.configName, this.dataSource);
        }
        if (this.dialect != null) {
            this.config.dialect = this.dialect;
        }
        if (this.showSql != null) {
            this.config.showSql = this.showSql;
        }
        if (this.devMode != null) {
            this.config.devMode = this.devMode;
        }
        if (this.transactionLevel != null) {
            this.config.transactionLevel = this.transactionLevel;
        }
        if (this.containerFactory != null) {
            this.config.containerFactory = this.containerFactory;
        }
        if (this.cache != null) {
            this.config.cache = this.cache;
        }
        new TableBuilder().build(this.tableList, this.config);
        DbKit.addConfig(this.config);
        Db.init();
        this.isStarted = true;
        return true;
    }

    @Override
    public boolean stop() {
        this.isStarted = false;
        return true;
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory, ICache cache) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        ActiveRecordPlugin arp = new ActiveRecordPlugin(new NullDataSource());
        arp.setDialect(dialect);
        arp.setContainerFactory(containerFactory);
        arp.setCache(cache);
        arp.start();
        DbKit.brokenConfig = arp.config;
    }

    public static void useAsDataTransfer(IContainerFactory containerFactory) {
        ActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), containerFactory, new EhCache());
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory) {
        ActiveRecordPlugin.useAsDataTransfer(dialect, containerFactory, new EhCache());
    }

    public static void useAsDataTransfer(Dialect dialect) {
        ActiveRecordPlugin.useAsDataTransfer(dialect, IContainerFactory.defaultContainerFactory, new EhCache());
    }

    public static void useAsDataTransfer() {
        ActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), IContainerFactory.defaultContainerFactory, new EhCache());
    }
}

