/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.i18n;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.i18n.I18n;
import com.jfinal.i18n.Res;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;

public class I18nInterceptor
implements Interceptor {
    private String localeParaName = "_locale";
    private String resName = "_res";
    private boolean isSwitchView = false;

    public I18nInterceptor() {
    }

    public I18nInterceptor(String localeParaName, String resName) {
        if (StrKit.isBlank(localeParaName)) {
            throw new IllegalArgumentException("localeParaName can not be blank.");
        }
        if (StrKit.isBlank(resName)) {
            throw new IllegalArgumentException("resName can not be blank.");
        }
        this.localeParaName = localeParaName;
        this.resName = resName;
    }

    public I18nInterceptor(String localeParaName, String resName, boolean isSwitchView) {
        this(localeParaName, resName);
        this.isSwitchView = isSwitchView;
    }

    protected String getLocaleParaName() {
        return this.localeParaName;
    }

    protected String getResName() {
        return this.resName;
    }

    protected String getBaseName() {
        return I18n.defaultBaseName;
    }

    @Override
    public void intercept(Invocation inv) {
        String localeParaName;
        Controller c = inv.getController();
        String locale = c.getPara(localeParaName = this.getLocaleParaName());
        if (StrKit.notBlank(locale)) {
            c.setCookie(localeParaName, locale, 999999999);
        } else {
            locale = c.getCookie(localeParaName);
            if (StrKit.isBlank(locale)) {
                locale = I18n.defaultLocale;
            }
        }
        if (this.isSwitchView) {
            this.switchView(locale, c);
        } else {
            Res res = I18n.use(this.getBaseName(), locale);
            c.setAttr(this.getResName(), res);
        }
        inv.invoke();
    }

    public void switchView(String locale, Controller c) {
        String view;
        Render render = c.getRender();
        if (render != null && (view = render.getView()) != null) {
            view = view.startsWith("/") ? "/" + locale + view : locale + "/" + view;
            render.setView(view);
        }
    }
}

