/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render;

import com.jfinal.core.Controller;
import com.jfinal.kit.HashKit;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;

@Deprecated
public class CaptchaRender
extends Render {
    private static final int WIDTH = 80;
    private static final int HEIGHT = 26;
    private static final String[] strArr = new String[]{"3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"};
    private String captchaName;

    public CaptchaRender(String captchaName) {
        if (StrKit.isBlank(captchaName)) {
            throw new IllegalArgumentException("captchaName can not be blank");
        }
        this.captchaName = captchaName;
    }

    @Override
    public void render() {
        BufferedImage image = new BufferedImage(80, 26, 1);
        String vCode = this.drawGraphic(image);
        vCode = vCode.toUpperCase();
        vCode = HashKit.md5(vCode);
        Cookie cookie = new Cookie(this.captchaName, vCode);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        try {
            cookie.setHttpOnly(true);
        }
        catch (Exception e) {
            LogKit.logNothing(e);
        }
        this.response.addCookie(cookie);
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            sos = this.response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", (OutputStream)sos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (sos != null) {
                try {
                    sos.close();
                }
                catch (IOException e) {
                    LogKit.logNothing(e);
                }
            }
        }
    }

    private String drawGraphic(BufferedImage image) {
        Graphics2D g = image.createGraphics();
        Random random = new Random();
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, 80, 26);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(this.getRandColor(160, 200));
        for (int i = 0; i < 155; ++i) {
            int x = random.nextInt(80);
            int y = random.nextInt(26);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }
        String sRand = "";
        for (int i = 0; i < 4; ++i) {
            String rand = String.valueOf(strArr[random.nextInt(strArr.length)]);
            sRand = sRand + rand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            ((Graphics)g).drawString(rand, 16 * i + 11, 19);
        }
        g.dispose();
        return sRand;
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public static boolean validate(Controller controller, String userInputCaptcha, String captchaName) {
        if (StrKit.isBlank(userInputCaptcha)) {
            return false;
        }
        userInputCaptcha = userInputCaptcha.toUpperCase();
        boolean result = (userInputCaptcha = HashKit.md5(userInputCaptcha)).equals(controller.getCookie(captchaName));
        if (result) {
            controller.removeCookie(captchaName);
        }
        return result;
    }
}

