/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.JFinalSession;
import com.jfinal.render.JsonRender;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;

public class SessionInViewInterceptor
implements Interceptor {
    private boolean createSession = false;

    public SessionInViewInterceptor() {
    }

    public SessionInViewInterceptor(boolean createSession) {
        this.createSession = createSession;
    }

    @Override
    public void intercept(Invocation inv) {
        inv.invoke();
        Controller c = inv.getController();
        if (c.getRender() instanceof JsonRender) {
            return;
        }
        HttpSession hs = c.getSession(this.createSession);
        if (hs != null) {
            JFinalSession session = new JFinalSession(hs);
            Enumeration names = hs.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                session.put(name, hs.getAttribute(name));
            }
            c.setAttr("session", session);
        }
    }
}

