/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.core.Config;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class TypeConverter {
    private static final String timeStampPattern = "yyyy-MM-dd HH:mm:ss";
    private static final String datePattern = "yyyy-MM-dd";
    private static final int timeStampLen = "yyyy-MM-dd HH:mm:ss".length();

    TypeConverter() {
    }

    public static final Object convert(Class<?> type, String s) throws ParseException {
        if (type == String.class) {
            return "".equals(s) ? null : s;
        }
        if ("".equals(s = s.trim())) {
            return null;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(s);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(s);
        }
        if (type == Date.class) {
            if (s.length() >= timeStampLen) {
                return new SimpleDateFormat(timeStampPattern).parse(s);
            }
            return new SimpleDateFormat(datePattern).parse(s);
        }
        if (type == java.sql.Date.class) {
            if (s.length() >= timeStampLen) {
                return new java.sql.Date(new SimpleDateFormat(timeStampPattern).parse(s).getTime());
            }
            return new java.sql.Date(new SimpleDateFormat(datePattern).parse(s).getTime());
        }
        if (type == Time.class) {
            return Time.valueOf(s);
        }
        if (type == Timestamp.class) {
            if (s.length() >= timeStampLen) {
                return Timestamp.valueOf(s);
            }
            return new Timestamp(new SimpleDateFormat(datePattern).parse(s).getTime());
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(s);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            String value = s.toLowerCase();
            if ("1".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("0".equals(value) || "false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: " + s);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (type == BigInteger.class) {
            return new BigInteger(s);
        }
        if (type == byte[].class) {
            return s.getBytes();
        }
        if (Config.getConstants().getDevMode()) {
            throw new RuntimeException("Please add code in " + TypeConverter.class + ". The type can't be converted: " + type.getName());
        }
        throw new RuntimeException(type.getName() + " can not be converted, please use other type of attributes in your model!");
    }
}

