/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.core.Controller;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Routes {
    private static String baseViewPath;
    private Map<String, Class<? extends Controller>> map = new HashMap<String, Class<? extends Controller>>();
    private Map<String, String> viewPathMap = new HashMap<String, String>();

    public abstract void config();

    public Routes add(Routes routes) {
        if (routes != null) {
            routes.config();
            for (Map.Entry<String, Class<? extends Controller>> e : routes.map.entrySet()) {
                String controllerKey = e.getKey();
                if (this.map.containsKey(controllerKey)) {
                    throw new IllegalArgumentException("The controllerKey already exists: " + controllerKey);
                }
                this.map.put(controllerKey, e.getValue());
                this.viewPathMap.put(controllerKey, routes.getViewPath(controllerKey));
            }
        }
        return this;
    }

    public Routes add(String controllerKey, Class<? extends Controller> controllerClass, String viewPath) {
        if (controllerKey == null) {
            throw new IllegalArgumentException("The controllerKey can not be null");
        }
        if ("".equals(controllerKey = controllerKey.trim())) {
            throw new IllegalArgumentException("The controllerKey can not be blank");
        }
        if (controllerClass == null) {
            throw new IllegalArgumentException("The controllerClass can not be null");
        }
        if (!controllerKey.startsWith("/")) {
            controllerKey = "/" + controllerKey;
        }
        if (this.map.containsKey(controllerKey)) {
            throw new IllegalArgumentException("The controllerKey already exists: " + controllerKey);
        }
        this.map.put(controllerKey, controllerClass);
        if (viewPath == null || "".equals(viewPath.trim())) {
            viewPath = controllerKey;
        }
        if (!(viewPath = viewPath.trim()).startsWith("/")) {
            viewPath = "/" + viewPath;
        }
        if (!viewPath.endsWith("/")) {
            viewPath = viewPath + "/";
        }
        if (baseViewPath != null) {
            viewPath = baseViewPath + viewPath;
        }
        this.viewPathMap.put(controllerKey, viewPath);
        return this;
    }

    public Routes add(String controllerKey, Class<? extends Controller> controllerClass) {
        return this.add(controllerKey, controllerClass, controllerKey);
    }

    public Set<Map.Entry<String, Class<? extends Controller>>> getEntrySet() {
        return this.map.entrySet();
    }

    public String getViewPath(String key) {
        return this.viewPathMap.get(key);
    }

    static void setBaseViewPath(String baseViewPath) {
        if (baseViewPath == null) {
            throw new IllegalArgumentException("The baseViewPath can not be null");
        }
        if ("".equals(baseViewPath = baseViewPath.trim())) {
            throw new IllegalArgumentException("The baseViewPath can not be blank");
        }
        if (!baseViewPath.startsWith("/")) {
            baseViewPath = "/" + baseViewPath;
        }
        if (baseViewPath.endsWith("/")) {
            baseViewPath = baseViewPath.substring(0, baseViewPath.length() - 1);
        }
        Routes.baseViewPath = baseViewPath;
    }

    public void clear() {
        this.map.clear();
        this.viewPathMap.clear();
        this.map = null;
        this.viewPathMap = null;
    }
}

