/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrick.collection.iterator.ArrayIterator;
import jetbrick.collection.iterator.EmptyIterator;
import jetbrick.collection.iterator.LoopIterator;

public final class JetForIterator
implements Iterator<Object> {
    protected final Iterator<?> iterator;
    protected final int size;
    protected int index;
    protected JetForIterator outer;

    public JetForIterator(Object items) {
        if (items == null) {
            this.iterator = EmptyIterator.INSTANCE;
            this.size = 0;
        } else if (items instanceof Iterator) {
            if (items instanceof LoopIterator) {
                this.iterator = (Iterator)items;
                this.size = ((LoopIterator)items).size();
            } else {
                List<?> list = this.asList((Iterator)items);
                this.iterator = list.iterator();
                this.size = list.size();
            }
        } else if (items instanceof Iterable) {
            if (items instanceof Collection) {
                this.iterator = ((Iterable)items).iterator();
                this.size = ((Collection)items).size();
            } else {
                List<?> list = this.asList(((Iterable)items).iterator());
                this.iterator = list.iterator();
                this.size = list.size();
            }
        } else if (items instanceof Map) {
            this.iterator = ((Map)items).entrySet().iterator();
            this.size = ((Map)items).size();
        } else if (items instanceof Enumeration) {
            ArrayList list = Collections.list((Enumeration)items);
            this.iterator = list.iterator();
            this.size = list.size();
        } else if (items.getClass().isArray()) {
            this.iterator = new ArrayIterator(items);
            this.size = Array.getLength(items);
        } else if (items instanceof Class && ((Class)items).isEnum()) {
            List list = Arrays.asList(((Class)items).getEnumConstants());
            this.iterator = list.iterator();
            this.size = list.size();
        } else {
            this.iterator = Collections.singleton(items).iterator();
            this.size = 1;
        }
        this.index = 0;
    }

    private List<?> asList(Iterator<?> it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Object next() {
        Object value = this.iterator.next();
        ++this.index;
        return value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFirst() {
        return this.index == 1;
    }

    public boolean isLast() {
        return !this.iterator.hasNext();
    }

    public boolean isOdd() {
        return this.index % 2 != 0;
    }

    public boolean isEven() {
        return this.index % 2 == 0;
    }

    public void setOuter(JetForIterator outer) {
        this.outer = outer;
    }

    public JetForIterator getOuter() {
        return this.outer;
    }
}

