/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.PropertyInfo;
import jetbrick.typecast.TypeCastUtils;
import jetbrick.util.ClassLoaderUtils;
import jetbrick.util.ClassUtils;
import jetbrick.util.IdentifiedNameUtils;
import jetbrick.util.StringUtils;

public abstract class AbstractConfig {
    protected final Map<String, String> config;
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");

    public AbstractConfig(Map<String, String> map) {
        this.config = new HashMap<String, String>(map);
    }

    public AbstractConfig(Properties props) {
        this.config = new HashMap<String, String>(props.size());
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            this.config.put(key, value);
        }
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public int size() {
        return this.config.size();
    }

    public Set<String> keySet() {
        return this.config.keySet();
    }

    public Set<String> keySet(String prefix) {
        LinkedHashSet keys = new LinkedHashSet();
        for (String key : this.config.keySet()) {
            if (!key.startsWith(prefix)) continue;
            keys.add(key);
        }
        return keys.isEmpty() ? Collections.emptySet() : keys;
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.config);
    }

    protected <T> T doGetValue(String name, Class<T> targetClass, String defaultValue) {
        String value = this.config.get(name);
        return this.stringAsObject(value, targetClass, defaultValue);
    }

    protected <T> List<T> doGetList(String name, Class<T> elementType, String defaultValues) {
        String valueList = this.config.get(name);
        if ((valueList = StringUtils.trimToNull(valueList)) == null) {
            valueList = defaultValues;
        }
        if (valueList == null || valueList.length() == 0) {
            return Collections.emptyList();
        }
        valueList = this.resolve(valueList);
        String[] values = StringUtils.split(valueList, ',');
        ArrayList<T> results = new ArrayList<T>(values.length);
        for (String value : values) {
            T object = this.stringAsObject(value, elementType, null);
            if (object == null) continue;
            results.add(object);
        }
        return Collections.unmodifiableList(results);
    }

    private <T> T stringAsObject(String value, Class<T> targetClass, String defaultValue) {
        if ((value = StringUtils.trimToNull(value)) == null) {
            value = defaultValue;
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        value = this.resolve(value);
        if (targetClass == String.class) {
            return (T)value;
        }
        if (value.startsWith("$")) {
            return this.aliasNameAsObject(value, targetClass);
        }
        if (targetClass == Object.class) {
            return this.aliasNameAsObject(value, targetClass);
        }
        if (TypeCastUtils.support(targetClass)) {
            return TypeCastUtils.convert(value, targetClass);
        }
        if (ClassUtils.available(value)) {
            return this.aliasNameAsObject(value, targetClass);
        }
        throw new IllegalStateException("Cannot convert to " + targetClass + " from `" + value + "`");
    }

    protected <T> T aliasNameAsObject(String aliasName, Class<T> targetClass) {
        Class<?> cls;
        Set<String> propNames;
        String className;
        if (aliasName.startsWith("$")) {
            className = this.doGetValue(aliasName, String.class, null);
            if (className != null) {
                propNames = this.keySet(aliasName.concat("."));
            } else {
                aliasName = aliasName.substring(1);
                className = this.doGetValue(aliasName, String.class, null);
                propNames = this.keySet(aliasName.concat("."));
            }
        } else {
            className = aliasName;
            propNames = null;
        }
        try {
            cls = ClassLoaderUtils.loadClassEx(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (!targetClass.isAssignableFrom(cls)) {
            throw new IllegalStateException("cannot convert `" + className + "` to " + targetClass);
        }
        return this.newInstance(aliasName, cls, propNames);
    }

    protected <T> T newInstance(String aliasName, Class<?> cls, Set<String> propNames) {
        Object obj;
        try {
            obj = this.objectNewInstance(cls);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (propNames != null && propNames.size() > 0) {
            KlassInfo klass = KlassInfo.create(cls);
            for (String propName : propNames) {
                Object value;
                String name = propName.substring(aliasName.length() + 1);
                PropertyInfo p = klass.getProperty(name);
                if (p == null || !p.writable()) {
                    throw new IllegalStateException("No set" + IdentifiedNameUtils.capitalize(name) + " found in " + cls);
                }
                Class<?> type = p.getRawType(klass);
                if (type == List.class || type == Collection.class || type.isArray()) {
                    Class<?> elementType = type.isArray() ? type.getComponentType() : p.getRawComponentType(cls, 0);
                    value = this.doGetList(propName, elementType, null);
                    if (type.isArray()) {
                        value = TypeCastUtils.convertToArray(value, elementType);
                    }
                } else {
                    value = this.doGetValue(propName, type, null);
                }
                p.set(obj, value);
            }
        }
        this.objectInitialize(obj);
        return (T)obj;
    }

    protected <T> T objectNewInstance(Class<T> cls) throws Exception {
        return cls.newInstance();
    }

    protected void objectInitialize(Object object) {
    }

    public String resolve(String value) {
        if (value == null || !value.contains("${")) {
            return value;
        }
        Matcher matcher = PLACE_HOLDER_PATTERN.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(1);
            String val = null;
            if (name.startsWith("env:")) {
                name = name.substring(4);
                val = System.getenv(name);
            } else {
                val = this.doGetValue(name, String.class, null);
                if (val == null) {
                    val = System.getProperty(name);
                }
            }
            if (val == null) {
                throw new IllegalStateException("cannot find variable `" + value + "` in environment variables");
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(val));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

