/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ListOrderedMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final Map<K, LinkedEntry<K, V>> map;
    private LinkedEntry<K, V> header;
    private transient Set<Map.Entry<K, V>> entries;
    private transient Set<K> keys;
    private transient Collection<V> values;
    private transient List<Map.Entry<K, V>> entryList;
    private transient List<K> keyList;
    private transient List<V> valueList;

    public ListOrderedMap() {
        this.map = new HashMap<K, LinkedEntry<K, V>>();
        this.createHeader();
    }

    public ListOrderedMap(int initialCapacity) {
        this.map = new HashMap<K, LinkedEntry<K, V>>(initialCapacity);
        this.createHeader();
    }

    public ListOrderedMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap<K, LinkedEntry<K, V>>(initialCapacity, loadFactor);
        this.createHeader();
    }

    public ListOrderedMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    private void createHeader() {
        this.header = new LinkedEntry();
        ((LinkedEntry)this.header).prev = (((LinkedEntry)this.header).next = (LinkedEntry)this.header);
    }

    public Map.Entry<K, V> getEntry(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        LinkedEntry entry = ((LinkedEntry)this.header).next;
        for (int i = 0; i < index; ++i) {
            entry = entry.next;
        }
        return entry;
    }

    public K getKey(int index) {
        return this.getEntry(index).getKey();
    }

    public V getValue(int index) {
        return this.getEntry(index).getValue();
    }

    public Map.Entry<K, V> put(int index, K key, V value) {
        LinkedEntry<K, V> entry;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        LinkedEntry old = ((LinkedEntry)this.header).next;
        boolean before = false;
        for (int i = 0; i < index; ++i) {
            old = old.next;
            if (key != old.key && (key == null || !key.equals(old.key))) continue;
            before = true;
        }
        if (before) {
            old = old.next;
        }
        if ((entry = this.map.get(key)) != null) {
            if (index == this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (entry != old) {
                entry.moveBefore(old);
            }
            entry.value = value;
        } else {
            entry = new LinkedEntry<K, V>(key, value);
            entry.insertBefore(old);
            this.map.put(key, entry);
        }
        return old;
    }

    public void putAll(int index, Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(index++, entry.getKey(), entry.getValue());
        }
    }

    public Map.Entry<K, V> remove(int index) {
        Map.Entry<K, V> entry = this.getEntry(index);
        this.remove(entry.getKey());
        return entry;
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntriesIterator();
    }

    public Map.Entry<K, V>[] toArray() {
        int size = this.size();
        LinkedEntry[] entries = new LinkedEntry[size];
        LinkedEntry entry = ((LinkedEntry)this.header).next;
        for (int i = 0; i < size; ++i) {
            entries[i] = entry;
            entry = entry.next;
        }
        return entries;
    }

    @Override
    public V get(Object key) {
        LinkedEntry<K, V> entry = this.map.get(key);
        return (V)(entry != null ? entry.value : null);
    }

    @Override
    public V put(K key, V value) {
        LinkedEntry<K, V> entry = this.map.get(key);
        if (entry != null) {
            Object old = entry.value;
            entry.value = value;
            return (V)old;
        }
        entry = new LinkedEntry<K, V>(key, value);
        entry.insertBefore(this.header);
        this.map.put(key, entry);
        return null;
    }

    @Override
    public V remove(Object key) {
        LinkedEntry<K, V> entry = this.map.get(key);
        if (entry != null) {
            entry.remove();
            this.map.remove(key);
            return (V)entry.value;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (V v : this.values()) {
                if (!value.equals(v)) continue;
                return true;
            }
        } else {
            for (V v : this.values()) {
                if (v != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.createHeader();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return ListOrderedMap.this.map.size();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntriesIterator();
                }
            };
        }
        return this.entries;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return ListOrderedMap.this.map.size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeysIterator();
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return ListOrderedMap.this.map.size();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValuesIterator();
                }
            };
        }
        return this.values;
    }

    public List<Map.Entry<K, V>> entryList() {
        if (this.entryList == null) {
            this.entryList = new AbstractList<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return ListOrderedMap.this.map.size();
                }

                @Override
                public Map.Entry<K, V> get(int index) {
                    return ListOrderedMap.this.getEntry(index);
                }
            };
        }
        return this.entryList;
    }

    public List<K> keyList() {
        if (this.keyList == null) {
            this.keyList = new AbstractList<K>(){

                @Override
                public int size() {
                    return ListOrderedMap.this.map.size();
                }

                @Override
                public K get(int index) {
                    return ListOrderedMap.this.getKey(index);
                }
            };
        }
        return this.keyList;
    }

    public List<V> valueList() {
        if (this.valueList == null) {
            this.valueList = new AbstractList<V>(){

                @Override
                public int size() {
                    return ListOrderedMap.this.map.size();
                }

                @Override
                public V get(int index) {
                    return ListOrderedMap.this.getValue(index);
                }

                @Override
                public V set(int index, V element) {
                    return ListOrderedMap.this.getEntry(index).setValue(element);
                }
            };
        }
        return this.valueList;
    }

    @Override
    public ListOrderedMap<K, V> clone() {
        return new ListOrderedMap<K, V>(this);
    }

    static class MapEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected K key;
        protected V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object k = entry.getKey();
            if (k == this.key || k != null && k.equals(this.key)) {
                Object v = entry.getValue();
                return v == this.value || v != null && v.equals(this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    final class ValuesIterator
    extends OrderedMapIterator<V> {
        ValuesIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    final class KeysIterator
    extends OrderedMapIterator<K> {
        KeysIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    final class EntriesIterator
    extends OrderedMapIterator<Map.Entry<K, V>> {
        EntriesIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    abstract class OrderedMapIterator<E>
    implements Iterator<E> {
        private LinkedEntry<K, V> curr;
        private LinkedEntry<K, V> prev;

        public OrderedMapIterator() {
            this.curr = ListOrderedMap.this.header.next;
        }

        @Override
        public boolean hasNext() {
            return this.curr != ListOrderedMap.this.header;
        }

        @Override
        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            ListOrderedMap.this.map.remove(this.prev.key);
            this.prev.remove();
            this.prev = null;
        }

        protected LinkedEntry<K, V> nextEntry() {
            if (this.curr == ListOrderedMap.this.header) {
                throw new NoSuchElementException();
            }
            this.prev = this.curr;
            this.curr = this.curr.next;
            return this.prev;
        }
    }

    static final class LinkedEntry<K, V>
    extends MapEntry<K, V> {
        private static final long serialVersionUID = 1L;
        private LinkedEntry<K, V> prev;
        private LinkedEntry<K, V> next;

        public LinkedEntry() {
            super(null, null);
        }

        public LinkedEntry(K key, V value) {
            super(key, value);
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }

        public void insertBefore(LinkedEntry<K, V> entry) {
            this.next = entry;
            this.prev = entry.prev;
            entry.prev = this;
            this.prev.next = this;
        }

        public void moveBefore(LinkedEntry<K, V> entry) {
            this.remove();
            this.insertBefore(entry);
        }

        @Override
        public String toString() {
            return this.value != null ? this.value.toString() : "null";
        }
    }
}

