/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import jetbrick.bean.Executable;
import jetbrick.bean.Invoker;
import jetbrick.bean.JdkReflectionUtils;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.TypeResolverUtils;
import jetbrick.bean.asm.AsmAccessor;
import jetbrick.util.ExceptionUtils;
import jetbrick.util.IdentifiedNameUtils;

public final class MethodInfo
extends Executable
implements Invoker,
Comparable<MethodInfo> {
    private final KlassInfo declaringKlass;
    private final Method method;
    private final int offset;

    public static MethodInfo create(Method method) {
        KlassInfo klass = KlassInfo.create(method.getDeclaringClass());
        return klass.getDeclaredMethod(method);
    }

    protected MethodInfo(KlassInfo declaringKlass, Method method, int offset) {
        this.declaringKlass = declaringKlass;
        this.method = method;
        this.offset = offset;
        JdkReflectionUtils.setAccessible(method);
    }

    @Override
    public KlassInfo getDeclaringKlass() {
        return this.declaringKlass;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getParameterCount() {
        return this.method.getParameterTypes().length;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Class<?> getRawReturnType(KlassInfo declaringKlass) {
        return this.getRawReturnType(declaringKlass.getType());
    }

    public Class<?> getRawReturnType(Class<?> declaringClass) {
        return TypeResolverUtils.getRawType(this.method.getGenericReturnType(), declaringClass);
    }

    public Class<?> getRawReturnComponentType(Class<?> declaringClass, int componentIndex) {
        return TypeResolverUtils.getComponentType(this.method.getGenericReturnType(), declaringClass, componentIndex);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isReadMethod() {
        Class<?> resultType = this.method.getReturnType();
        if (this.method.getParameterTypes().length == 0 && resultType != Void.TYPE) {
            String name = this.method.getName();
            if (name.length() > 3 && name.startsWith("get")) {
                return true;
            }
            if (name.length() > 2 && name.startsWith("is")) {
                return resultType == Boolean.TYPE || resultType == Boolean.class;
            }
        }
        return false;
    }

    public boolean isWriteMethod() {
        String name;
        Class<?> resultType = this.method.getReturnType();
        return this.method.getParameterTypes().length == 1 && resultType == Void.TYPE && (name = this.method.getName()).length() > 3 && name.startsWith("set");
    }

    public String getPropertyName() {
        if (!this.isReadMethod() && !this.isWriteMethod()) {
            throw new IllegalStateException("method is not a getter/setter: " + this.toString());
        }
        String name = this.method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("set")) {
            name = name.substring(3);
        }
        return IdentifiedNameUtils.decapitalize(name);
    }

    @Override
    public Object invoke(Object object, Object ... args) {
        AsmAccessor accessor = this.declaringKlass.getAsmAccessor();
        if (accessor == null) {
            try {
                return JdkReflectionUtils.invoke(this.method, object, args);
            }
            catch (Exception e) {
                throw ExceptionUtils.unchecked(e);
            }
        }
        return accessor.invoke(object, this.offset, args);
    }

    @Override
    public int compareTo(MethodInfo o) {
        return this.getSignature().compareTo(o.getSignature());
    }
}

