/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import jetbrick.bean.FieldInfo;
import jetbrick.bean.MethodInfo;

public final class Filters {
    public static final FieldFilter PUBLIC_FIELD = new FieldFilter(){

        @Override
        public boolean accept(FieldInfo field) {
            return field.isPublic();
        }
    };
    public static final FieldFilter STATIC_FIELD = new FieldFilter(){

        @Override
        public boolean accept(FieldInfo field) {
            return field.isStatic();
        }
    };
    public static final FieldFilter INSTANCE_FIELD = new FieldFilter(){

        @Override
        public boolean accept(FieldInfo field) {
            return !field.isStatic();
        }
    };
    public static final FieldFilter PUBLIC_INSTANCE_FIELD = new FieldFilter(){

        @Override
        public boolean accept(FieldInfo field) {
            return field.isPublic() && !field.isStatic();
        }
    };
    public static final FieldFilter PUBLIC_STATIC_FINAL_FIELD = new FieldFilter(){

        @Override
        public boolean accept(FieldInfo field) {
            return field.isPublic() && field.isStatic() && field.isFinal();
        }
    };
    public static final MethodFilter PUBLIC_METHOD = new MethodFilter(){

        @Override
        public boolean accept(MethodInfo method) {
            return method.isPublic();
        }
    };
    public static final MethodFilter STATIC_METHOD = new MethodFilter(){

        @Override
        public boolean accept(MethodInfo method) {
            return method.isStatic();
        }
    };
    public static final MethodFilter INSTANCE_METHOD = new MethodFilter(){

        @Override
        public boolean accept(MethodInfo method) {
            return !method.isStatic();
        }
    };
    public static final MethodFilter PUBLIC_INSTANCE_METHOD = new MethodFilter(){

        @Override
        public boolean accept(MethodInfo method) {
            return method.isPublic() && !method.isStatic();
        }
    };

    public static interface MethodFilter {
        public boolean accept(MethodInfo var1);
    }

    public static interface FieldFilter {
        public boolean accept(FieldInfo var1);
    }
}

