/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tm.core.DTXContext;
import com.codingapi.txlcn.tm.core.DTXContextRegistry;
import com.codingapi.txlcn.tm.core.TransactionManager;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.params.NotifyGroupParams;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_notify-group")
public class NotifyGroupExecuteService
implements RpcExecuteService {
    private static final TxLogger txLogger = TxLogger.newLogger(NotifyGroupExecuteService.class);
    private final TransactionManager transactionManager;
    private final DTXContextRegistry dtxContextRegistry;

    @Autowired
    public NotifyGroupExecuteService(TransactionManager transactionManager, DTXContextRegistry dtxContextRegistry) {
        this.transactionManager = transactionManager;
        this.dtxContextRegistry = dtxContextRegistry;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        try {
            DTXContext dtxContext = this.dtxContextRegistry.get(transactionCmd.getGroupId());
            NotifyGroupParams notifyGroupParams = (NotifyGroupParams)transactionCmd.getMsg().loadBean(NotifyGroupParams.class);
            int commitState = notifyGroupParams.getState();
            int transactionState = this.transactionManager.transactionStateFromFastStorage(transactionCmd.getGroupId());
            if (transactionState == 0) {
                commitState = 0;
            }
            txLogger.txTrace(transactionCmd.getGroupId(), "", "notify group state: {}", new Object[]{notifyGroupParams.getState()});
            if (commitState == 1) {
                this.transactionManager.commit(dtxContext);
            } else if (commitState == 0) {
                this.transactionManager.rollback(dtxContext);
            }
            if (transactionState == 0) {
                txLogger.txTrace(transactionCmd.getGroupId(), "", "mandatory rollback for user.", new Object[0]);
            }
            Integer n = commitState;
            return n;
        }
        catch (TransactionException e) {
            throw new TxManagerException((Throwable)e);
        }
        finally {
            this.transactionManager.close(transactionCmd.getGroupId());
            txLogger.txTrace(transactionCmd.getGroupId(), "", "notify group successfully.", new Object[0]);
        }
    }
}

