/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class BooleanMutex {
    private Sync sync = new Sync();

    public BooleanMutex() {
        this.set(false);
    }

    public BooleanMutex(Boolean mutex) {
        this.set(mutex);
    }

    public void get() throws InterruptedException {
        this.sync.innerGet();
    }

    public void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.sync.innerGet(unit.toNanos(timeout));
    }

    public void set(Boolean mutex) {
        if (mutex.booleanValue()) {
            this.sync.innerSetTrue();
        } else {
            this.sync.innerSetFalse();
        }
    }

    public boolean state() {
        return this.sync.innerState();
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 2559471934544126329L;
        private static final int TRUE = 1;
        private static final int FALSE = 2;

        private Sync() {
        }

        private boolean isTrue(int state) {
            return (state & 1) != 0;
        }

        @Override
        protected int tryAcquireShared(int state) {
            return this.isTrue(this.getState()) ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        boolean innerState() {
            return this.isTrue(this.getState());
        }

        void innerGet() throws InterruptedException {
            this.acquireSharedInterruptibly(0);
        }

        void innerGet(long nanosTimeout) throws InterruptedException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
        }

        void innerSetTrue() {
            int s;
            do {
                if ((s = this.getState()) != 1) continue;
                return;
            } while (!this.compareAndSetState(s, 1));
            this.releaseShared(0);
        }

        void innerSetFalse() {
            int s;
            do {
                if ((s = this.getState()) != 2) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
        }
    }
}

