/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.Assert;

@Deprecated
public final class OAuth2AccessTokenJackson2Serializer
extends StdSerializer<OAuth2AccessToken> {
    public OAuth2AccessTokenJackson2Serializer() {
        super(OAuth2AccessToken.class);
    }

    public void serialize(OAuth2AccessToken token, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Set<String> scope;
        Date expiration;
        jgen.writeStartObject();
        jgen.writeStringField("access_token", token.getValue());
        jgen.writeStringField("token_type", token.getTokenType());
        OAuth2RefreshToken refreshToken = token.getRefreshToken();
        if (refreshToken != null) {
            jgen.writeStringField("refresh_token", refreshToken.getValue());
        }
        if ((expiration = token.getExpiration()) != null) {
            long now = System.currentTimeMillis();
            jgen.writeNumberField("expires_in", (expiration.getTime() - now) / 1000L);
        }
        if ((scope = token.getScope()) != null && !scope.isEmpty()) {
            StringBuffer scopes = new StringBuffer();
            for (String s : scope) {
                Assert.hasLength((String)s, (String)("Scopes cannot be null or empty. Got " + scope + ""));
                scopes.append(s);
                scopes.append(" ");
            }
            jgen.writeStringField("scope", scopes.substring(0, scopes.length() - 1));
        }
        Map<String, Object> additionalInformation = token.getAdditionalInformation();
        for (String key : additionalInformation.keySet()) {
            jgen.writeObjectField(key, additionalInformation.get(key));
        }
        jgen.writeEndObject();
    }
}

