/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;

class JwtHeaderConverter
implements Converter<String, Map<String, String>> {
    private final JsonFactory factory = new JsonFactory();

    JwtHeaderConverter() {
    }

    public Map<String, String> convert(String token) {
        HashMap<String, String> headers;
        byte[] decodedHeader;
        int headerEndIndex = token.indexOf(46);
        if (headerEndIndex == -1) {
            throw new InvalidTokenException("Invalid JWT. Missing JOSE Header.");
        }
        try {
            decodedHeader = Codecs.b64UrlDecode((CharSequence)token.substring(0, headerEndIndex));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidTokenException("Invalid JWT. Malformed JOSE Header.", ex);
        }
        JsonParser parser = null;
        try {
            parser = this.factory.createParser(decodedHeader);
            headers = new HashMap<String, String>();
            if (parser.nextToken() == JsonToken.START_OBJECT) {
                while (parser.nextToken() == JsonToken.FIELD_NAME) {
                    String headerName = parser.getCurrentName();
                    parser.nextToken();
                    String headerValue = parser.getValueAsString();
                    headers.put(headerName, headerValue);
                }
            }
        }
        catch (IOException ex) {
            throw new InvalidTokenException("An I/O error occurred while reading the JWT: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (IOException iOException) {}
        }
        return headers;
    }
}

