/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DDLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.impl.OpenGaussStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.constant.DirectionType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.ValidateConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.DirectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.NameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterAggregateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterConversionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterDefaultPrivilegesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterDirectoryStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterDomainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterExtensionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterForeignTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterLanguageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterPackageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterSynonymStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterTextSearchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterTypeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussAlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCloseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCommentStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateAggregateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateCastStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateConversionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateDirectoryStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateDomainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateExtensionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateLanguageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreatePublicationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateSynonymStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateTextSearchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateTypeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDeallocateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDeclareStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropCastStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropConversionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropDirectoryStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropDomainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropExtensionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropLanguageStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropPublicationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropSequenceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropSynonymStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropTypeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussDropViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussFetchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussMoveStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussPrepareStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussTruncateStatement;

public final class OpenGaussDDLStatementSQLVisitor
extends OpenGaussStatementSQLVisitor
implements DDLSQLVisitor,
SQLStatementVisitor {
    public OpenGaussDDLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitCreateTable(OpenGaussStatementParser.CreateTableContext ctx) {
        OpenGaussCreateTableStatement result = new OpenGaussCreateTableStatement(null != ctx.ifNotExists());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(OpenGaussStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(OpenGaussStatementParser.AlterTableContext ctx) {
        OpenGaussAlterTableStatement result = new OpenGaussAlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause().tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ValidateConstraintDefinitionSegment) {
                    result.getValidateConstraintDefinitions().add((ValidateConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyConstraintDefinitionSegment) {
                    result.getModifyConstraintDefinitions().add((ModifyConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropConstraintDefinitionSegment) {
                    result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof RenameTableDefinitionSegment)) continue;
                result.setRenameTable(((RenameTableDefinitionSegment)each).getRenameTable());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterAggregate(OpenGaussStatementParser.AlterAggregateContext ctx) {
        return new OpenGaussAlterAggregateStatement();
    }

    @Override
    public ASTNode visitAlterDefaultPrivileges(OpenGaussStatementParser.AlterDefaultPrivilegesContext ctx) {
        return new OpenGaussAlterDefaultPrivilegesStatement();
    }

    @Override
    public ASTNode visitAlterDefinitionClause(OpenGaussStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterTableActions()) {
            for (OpenGaussStatementParser.AlterTableActionContext each : ctx.alterTableActions().alterTableAction()) {
                OpenGaussStatementParser.AddColumnSpecificationContext addColumnSpecification = each.addColumnSpecification();
                if (null != addColumnSpecification) {
                    result.getValue().addAll(((CollectionValue)this.visit((ParseTree)addColumnSpecification)).getValue());
                }
                if (null != each.addConstraintSpecification() && null != each.addConstraintSpecification().tableConstraint()) {
                    result.getValue().add((AddConstraintDefinitionSegment)this.visit((ParseTree)each.addConstraintSpecification()));
                }
                if (null != each.validateConstraintSpecification()) {
                    result.getValue().add((ValidateConstraintDefinitionSegment)this.visit((ParseTree)each.validateConstraintSpecification()));
                }
                if (null != each.modifyColumnSpecification()) {
                    result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)each.modifyColumnSpecification()));
                }
                if (null != each.modifyConstraintSpecification()) {
                    result.getValue().add((ModifyConstraintDefinitionSegment)this.visit((ParseTree)each.modifyConstraintSpecification()));
                }
                if (null != each.dropColumnSpecification()) {
                    result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)each.dropColumnSpecification()));
                }
                if (null == each.dropConstraintSpecification()) continue;
                result.getValue().add((DropConstraintDefinitionSegment)this.visit((ParseTree)each.dropConstraintSpecification()));
            }
        }
        if (null != ctx.renameTableSpecification()) {
            result.getValue().add((RenameTableDefinitionSegment)this.visit((ParseTree)ctx.renameTableSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterForeignTable(OpenGaussStatementParser.AlterForeignTableContext ctx) {
        return new OpenGaussAlterForeignTableStatement();
    }

    @Override
    public ASTNode visitAlterGroup(OpenGaussStatementParser.AlterGroupContext ctx) {
        return new OpenGaussAlterGroupStatement();
    }

    @Override
    public ASTNode visitAlterPackage(OpenGaussStatementParser.AlterPackageContext ctx) {
        return new OpenGaussAlterPackageStatement();
    }

    @Override
    public ASTNode visitAlterMaterializedView(OpenGaussStatementParser.AlterMaterializedViewContext ctx) {
        return new OpenGaussAlterMaterializedViewStatement();
    }

    @Override
    public ASTNode visitAddConstraintSpecification(OpenGaussStatementParser.AddConstraintSpecificationContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.tableConstraint()));
    }

    @Override
    public ASTNode visitValidateConstraintSpecification(OpenGaussStatementParser.ValidateConstraintSpecificationContext ctx) {
        return new ValidateConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitModifyConstraintSpecification(OpenGaussStatementParser.ModifyConstraintSpecificationContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitDropConstraintSpecification(OpenGaussStatementParser.DropConstraintSpecificationContext ctx) {
        return new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterDomain(OpenGaussStatementParser.AlterDomainContext ctx) {
        return new OpenGaussAlterDomainStatement();
    }

    @Override
    public ASTNode visitRenameTableSpecification(OpenGaussStatementParser.RenameTableSpecificationContext ctx) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        TableNameSegment tableName = new TableNameSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        result.setRenameTable(new SimpleTableSegment(tableName));
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(OpenGaussStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        OpenGaussStatementParser.ColumnDefinitionContext columnDefinition = ctx.columnDefinition();
        if (null != columnDefinition) {
            AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(ctx.columnDefinition().getStart().getStartIndex(), columnDefinition.getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)columnDefinition)));
            result.getValue().add(addColumnDefinition);
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(OpenGaussStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.columnConstraint().stream().anyMatch(each -> null != each.columnConstraintOption() && null != each.columnConstraintOption().primaryKey());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false);
        for (OpenGaussStatementParser.ColumnConstraintContext each2 : ctx.columnConstraint()) {
            if (null == each2.columnConstraintOption().tableName()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each2.columnConstraintOption().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraintUsingIndex(OpenGaussStatementParser.TableConstraintUsingIndexContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraint(OpenGaussStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintClause()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintClause().constraintName()));
        }
        if (null != ctx.tableConstraintOption().primaryKey()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableConstraintOption().columnNames(0))).getValue());
        }
        if (null != ctx.tableConstraintOption().FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableConstraintOption().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(OpenGaussStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.modifyColumn().columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false);
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(OpenGaussStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singletonList((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitRenameColumnSpecification(OpenGaussStatementParser.RenameColumnSpecificationContext ctx) {
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)this.visit((ParseTree)ctx.columnName(0)), (ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
    }

    @Override
    public ASTNode visitDropTable(OpenGaussStatementParser.DropTableContext ctx) {
        boolean containsCascade = null != ctx.dropTableOpt() && null != ctx.dropTableOpt().CASCADE();
        OpenGaussDropTableStatement result = new OpenGaussDropTableStatement(null != ctx.ifExists(), containsCascade);
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(OpenGaussStatementParser.TruncateTableContext ctx) {
        OpenGaussTruncateStatement result = new OpenGaussTruncateStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNamesClause())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(OpenGaussStatementParser.CreateIndexContext ctx) {
        OpenGaussCreateIndexStatement result = new OpenGaussCreateIndexStatement(null != ctx.ifNotExists());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.indexParams())).getValue());
        if (null == ctx.indexName()) {
            result.setGeneratedIndexStartIndex(Integer.valueOf(ctx.ON().getSymbol().getStartIndex() - 1));
        } else {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexParams(OpenGaussStatementParser.IndexParamsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.IndexElemContext each : ctx.indexElem()) {
            if (null == each.colId()) continue;
            result.getValue().add(new ColumnSegment(each.colId().start.getStartIndex(), each.colId().stop.getStopIndex(), new IdentifierValue(each.colId().getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(OpenGaussStatementParser.AlterIndexContext ctx) {
        OpenGaussAlterIndexStatement result = new OpenGaussAlterIndexStatement();
        result.setIndex(this.createIndexSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())));
        if (null != ctx.alterIndexDefinitionClause().renameIndexSpecification()) {
            result.setRenameIndex((IndexSegment)this.visit((ParseTree)ctx.alterIndexDefinitionClause().renameIndexSpecification().indexName()));
        }
        return result;
    }

    private IndexSegment createIndexSegment(SimpleTableSegment tableSegment) {
        IndexNameSegment indexName = new IndexNameSegment(tableSegment.getTableName().getStartIndex(), tableSegment.getTableName().getStopIndex(), tableSegment.getTableName().getIdentifier());
        IndexSegment result = new IndexSegment(tableSegment.getStartIndex(), tableSegment.getStopIndex(), indexName);
        tableSegment.getOwner().ifPresent(arg_0 -> ((IndexSegment)result).setOwner(arg_0));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(OpenGaussStatementParser.DropIndexContext ctx) {
        OpenGaussDropIndexStatement result = new OpenGaussDropIndexStatement(null != ctx.ifExists());
        result.getIndexes().addAll(this.createIndexSegments(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue()));
        return result;
    }

    private Collection<IndexSegment> createIndexSegments(Collection<SimpleTableSegment> tableSegments) {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        for (SimpleTableSegment each : tableSegments) {
            result.add(this.createIndexSegment(each));
        }
        return result;
    }

    @Override
    public ASTNode visitIndexNames(OpenGaussStatementParser.IndexNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getValue().add((IndexSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitTableNameClause(OpenGaussStatementParser.TableNameClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitTableNamesClause(OpenGaussStatementParser.TableNamesClauseContext ctx) {
        LinkedList<SimpleTableSegment> tableSegments = new LinkedList<SimpleTableSegment>();
        for (int i = 0; i < ctx.tableNameClause().size(); ++i) {
            tableSegments.add((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameClause(i)));
        }
        CollectionValue result = new CollectionValue();
        result.getValue().addAll(tableSegments);
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(OpenGaussStatementParser.AlterFunctionContext ctx) {
        return new OpenGaussAlterFunctionStatement();
    }

    @Override
    public ASTNode visitAlterProcedure(OpenGaussStatementParser.AlterProcedureContext ctx) {
        return new OpenGaussAlterProcedureStatement();
    }

    @Override
    public ASTNode visitCreateFunction(OpenGaussStatementParser.CreateFunctionContext ctx) {
        return new OpenGaussCreateFunctionStatement();
    }

    @Override
    public ASTNode visitCreateProcedure(OpenGaussStatementParser.CreateProcedureContext ctx) {
        return new OpenGaussCreateProcedureStatement();
    }

    @Override
    public ASTNode visitDropFunction(OpenGaussStatementParser.DropFunctionContext ctx) {
        return new OpenGaussDropFunctionStatement();
    }

    @Override
    public ASTNode visitDropView(OpenGaussStatementParser.DropViewContext ctx) {
        OpenGaussDropViewStatement result = new OpenGaussDropViewStatement();
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateView(OpenGaussStatementParser.CreateViewContext ctx) {
        OpenGaussCreateViewStatement result = new OpenGaussCreateViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitAlterView(OpenGaussStatementParser.AlterViewContext ctx) {
        OpenGaussAlterViewStatement result = new OpenGaussAlterViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        if (ctx.alterViewClauses() instanceof OpenGaussStatementParser.AlterRenameViewContext) {
            OpenGaussStatementParser.NameContext nameContext = ((OpenGaussStatementParser.AlterRenameViewContext)ctx.alterViewClauses()).name();
            result.setRenameView(new SimpleTableSegment(new TableNameSegment(nameContext.getStart().getStartIndex(), nameContext.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)nameContext.identifier()))));
        }
        return result;
    }

    @Override
    public ASTNode visitDropDatabase(OpenGaussStatementParser.DropDatabaseContext ctx) {
        OpenGaussDropDatabaseStatement result = new OpenGaussDropDatabaseStatement();
        result.setDatabaseName(((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue());
        result.setIfExists(null != ctx.ifExists());
        return result;
    }

    @Override
    public ASTNode visitDropServer(OpenGaussStatementParser.DropServerContext ctx) {
        return new OpenGaussDropServerStatement();
    }

    @Override
    public ASTNode visitDropProcedure(OpenGaussStatementParser.DropProcedureContext ctx) {
        return new OpenGaussDropProcedureStatement();
    }

    @Override
    public ASTNode visitDropPublication(OpenGaussStatementParser.DropPublicationContext ctx) {
        return new OpenGaussDropPublicationStatement();
    }

    @Override
    public ASTNode visitDropCast(OpenGaussStatementParser.DropCastContext ctx) {
        return new OpenGaussDropCastStatement();
    }

    @Override
    public ASTNode visitDropRule(OpenGaussStatementParser.DropRuleContext ctx) {
        return new OpenGaussDropRuleStatement();
    }

    @Override
    public ASTNode visitCreateDatabase(OpenGaussStatementParser.CreateDatabaseContext ctx) {
        OpenGaussCreateDatabaseStatement result = new OpenGaussCreateDatabaseStatement();
        result.setDatabaseName(((IdentifierValue)this.visit((ParseTree)ctx.name())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateSequence(OpenGaussStatementParser.CreateSequenceContext ctx) {
        OpenGaussCreateSequenceStatement result = new OpenGaussCreateSequenceStatement();
        result.setSequenceName(((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())).getTableName().getIdentifier().getValue());
        return result;
    }

    @Override
    public ASTNode visitAlterSequence(OpenGaussStatementParser.AlterSequenceContext ctx) {
        OpenGaussAlterSequenceStatement result = new OpenGaussAlterSequenceStatement();
        result.setSequenceName(((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName())).getTableName().getIdentifier().getValue());
        return result;
    }

    @Override
    public ASTNode visitDropSequence(OpenGaussStatementParser.DropSequenceContext ctx) {
        OpenGaussDropSequenceStatement result = new OpenGaussDropSequenceStatement();
        result.setSequenceNames(((CollectionValue)this.visit((ParseTree)ctx.qualifiedNameList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitDropSynonym(OpenGaussStatementParser.DropSynonymContext ctx) {
        return new OpenGaussDropSynonymStatement();
    }

    @Override
    public ASTNode visitDropType(OpenGaussStatementParser.DropTypeContext ctx) {
        return new OpenGaussDropTypeStatement();
    }

    @Override
    public ASTNode visitDropDirectory(OpenGaussStatementParser.DropDirectoryContext ctx) {
        return new OpenGaussDropDirectoryStatement();
    }

    @Override
    public ASTNode visitPrepare(OpenGaussStatementParser.PrepareContext ctx) {
        OpenGaussPrepareStatement result = new OpenGaussPrepareStatement();
        if (null != ctx.preparableStmt().select()) {
            result.setSelect((SelectStatement)this.visit((ParseTree)ctx.preparableStmt().select()));
        }
        if (null != ctx.preparableStmt().insert()) {
            result.setInsert((InsertStatement)this.visit((ParseTree)ctx.preparableStmt().insert()));
        }
        if (null != ctx.preparableStmt().update()) {
            result.setUpdate((UpdateStatement)this.visit((ParseTree)ctx.preparableStmt().update()));
        }
        if (null != ctx.preparableStmt().delete()) {
            result.setDelete((DeleteStatement)this.visit((ParseTree)ctx.preparableStmt().delete()));
        }
        return result;
    }

    @Override
    public ASTNode visitDeallocate(OpenGaussStatementParser.DeallocateContext ctx) {
        return new OpenGaussDeallocateStatement();
    }

    @Override
    public ASTNode visitCreateSynonym(OpenGaussStatementParser.CreateSynonymContext ctx) {
        return new OpenGaussCreateSynonymStatement();
    }

    @Override
    public ASTNode visitCreateAggregate(OpenGaussStatementParser.CreateAggregateContext ctx) {
        return new OpenGaussCreateAggregateStatement();
    }

    @Override
    public ASTNode visitCreatePublication(OpenGaussStatementParser.CreatePublicationContext ctx) {
        return new OpenGaussCreatePublicationStatement();
    }

    @Override
    public ASTNode visitCreateDirectory(OpenGaussStatementParser.CreateDirectoryContext ctx) {
        return new OpenGaussCreateDirectoryStatement();
    }

    @Override
    public ASTNode visitCreateTablespace(OpenGaussStatementParser.CreateTablespaceContext ctx) {
        return new OpenGaussCreateTablespaceStatement();
    }

    @Override
    public ASTNode visitAlterTablespace(OpenGaussStatementParser.AlterTablespaceContext ctx) {
        return new OpenGaussAlterTablespaceStatement();
    }

    @Override
    public ASTNode visitDropTablespace(OpenGaussStatementParser.DropTablespaceContext ctx) {
        return new OpenGaussDropTablespaceStatement();
    }

    @Override
    public ASTNode visitDropDomain(OpenGaussStatementParser.DropDomainContext ctx) {
        return new OpenGaussDropDomainStatement();
    }

    @Override
    public ASTNode visitCreateDomain(OpenGaussStatementParser.CreateDomainContext ctx) {
        return new OpenGaussCreateDomainStatement();
    }

    @Override
    public ASTNode visitCreateRule(OpenGaussStatementParser.CreateRuleContext ctx) {
        return new OpenGaussCreateRuleStatement();
    }

    @Override
    public ASTNode visitCreateLanguage(OpenGaussStatementParser.CreateLanguageContext ctx) {
        return new OpenGaussCreateLanguageStatement();
    }

    @Override
    public ASTNode visitCreateSchema(OpenGaussStatementParser.CreateSchemaContext ctx) {
        OpenGaussCreateSchemaStatement result = new OpenGaussCreateSchemaStatement();
        if (null != ctx.createSchemaClauses().colId()) {
            result.setSchemaName(new IdentifierValue(ctx.createSchemaClauses().colId().getText()));
        }
        if (null != ctx.createSchemaClauses().roleSpec() && null != ctx.createSchemaClauses().roleSpec().identifier()) {
            result.setUsername((IdentifierValue)this.visit((ParseTree)ctx.createSchemaClauses().roleSpec().identifier()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterSchema(OpenGaussStatementParser.AlterSchemaContext ctx) {
        OpenGaussAlterSchemaStatement result = new OpenGaussAlterSchemaStatement();
        result.setSchemaName((IdentifierValue)this.visit((ParseTree)ctx.name().get(0)));
        if (ctx.name().size() > 1) {
            result.setRenameSchema((IdentifierValue)this.visit((ParseTree)ctx.name().get(1)));
        }
        return result;
    }

    @Override
    public ASTNode visitDropSchema(OpenGaussStatementParser.DropSchemaContext ctx) {
        OpenGaussDropSchemaStatement result = new OpenGaussDropSchemaStatement();
        result.getSchemaNames().addAll(((CollectionValue)this.visit((ParseTree)ctx.nameList())).getValue());
        result.setContainsCascade(null != ctx.dropBehavior() && null != ctx.dropBehavior().CASCADE());
        return result;
    }

    @Override
    public ASTNode visitNameList(OpenGaussStatementParser.NameListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.nameList()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.nameList()));
        }
        if (null != ctx.name()) {
            result.getValue().add((IdentifierValue)this.visit((ParseTree)ctx.name()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterLanguage(OpenGaussStatementParser.AlterLanguageContext ctx) {
        return new OpenGaussAlterLanguageStatement();
    }

    @Override
    public ASTNode visitAlterSynonym(OpenGaussStatementParser.AlterSynonymContext ctx) {
        return new OpenGaussAlterSynonymStatement();
    }

    @Override
    public ASTNode visitAlterDirectory(OpenGaussStatementParser.AlterDirectoryContext ctx) {
        return new OpenGaussAlterDirectoryStatement();
    }

    @Override
    public ASTNode visitAlterRule(OpenGaussStatementParser.AlterRuleContext ctx) {
        return new OpenGaussAlterRuleStatement();
    }

    @Override
    public ASTNode visitAlterType(OpenGaussStatementParser.AlterTypeContext ctx) {
        return new OpenGaussAlterTypeStatement();
    }

    @Override
    public ASTNode visitDropLanguage(OpenGaussStatementParser.DropLanguageContext ctx) {
        return new OpenGaussDropLanguageStatement();
    }

    @Override
    public ASTNode visitCreateConversion(OpenGaussStatementParser.CreateConversionContext ctx) {
        return new OpenGaussCreateConversionStatement();
    }

    @Override
    public ASTNode visitCreateCast(OpenGaussStatementParser.CreateCastContext ctx) {
        return new OpenGaussCreateCastStatement();
    }

    @Override
    public ASTNode visitCreateType(OpenGaussStatementParser.CreateTypeContext ctx) {
        return new OpenGaussCreateTypeStatement();
    }

    @Override
    public ASTNode visitDropConversion(OpenGaussStatementParser.DropConversionContext ctx) {
        return new OpenGaussDropConversionStatement();
    }

    @Override
    public ASTNode visitAlterConversion(OpenGaussStatementParser.AlterConversionContext ctx) {
        return new OpenGaussAlterConversionStatement();
    }

    @Override
    public ASTNode visitCreateTextSearch(OpenGaussStatementParser.CreateTextSearchContext ctx) {
        return new OpenGaussCreateTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchDictionary(OpenGaussStatementParser.AlterTextSearchDictionaryContext ctx) {
        return new OpenGaussAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchTemplate(OpenGaussStatementParser.AlterTextSearchTemplateContext ctx) {
        return new OpenGaussAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitAlterTextSearchParser(OpenGaussStatementParser.AlterTextSearchParserContext ctx) {
        return new OpenGaussAlterTextSearchStatement();
    }

    @Override
    public ASTNode visitCreateExtension(OpenGaussStatementParser.CreateExtensionContext ctx) {
        return new OpenGaussCreateExtensionStatement();
    }

    @Override
    public ASTNode visitAlterExtension(OpenGaussStatementParser.AlterExtensionContext ctx) {
        return new OpenGaussAlterExtensionStatement();
    }

    @Override
    public ASTNode visitDropExtension(OpenGaussStatementParser.DropExtensionContext ctx) {
        return new OpenGaussDropExtensionStatement();
    }

    @Override
    public ASTNode visitDeclare(OpenGaussStatementParser.DeclareContext ctx) {
        OpenGaussDeclareStatement result = new OpenGaussDeclareStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitComment(OpenGaussStatementParser.CommentContext ctx) {
        if (null != ctx.commentClauses().objectTypeAnyName() && null != ctx.commentClauses().objectTypeAnyName().TABLE()) {
            return this.commentOnTable(ctx);
        }
        if (null != ctx.commentClauses().COLUMN()) {
            return this.commentOnColumn(ctx);
        }
        return new OpenGaussCommentStatement();
    }

    private OpenGaussCommentStatement commentOnColumn(OpenGaussStatementParser.CommentContext ctx) {
        OpenGaussCommentStatement result = new OpenGaussCommentStatement();
        Iterator<NameSegment> nameSegmentIterator = ((CollectionValue)this.visit((ParseTree)ctx.commentClauses().anyName())).getValue().iterator();
        Optional<NameSegment> columnName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        columnName.ifPresent(optional -> result.setColumn(new ColumnSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier())));
        this.setTableSegment(result, nameSegmentIterator);
        return result;
    }

    private OpenGaussCommentStatement commentOnTable(OpenGaussStatementParser.CommentContext ctx) {
        OpenGaussCommentStatement result = new OpenGaussCommentStatement();
        Iterator<NameSegment> nameSegmentIterator = ((CollectionValue)this.visit((ParseTree)ctx.commentClauses().anyName())).getValue().iterator();
        this.setTableSegment(result, nameSegmentIterator);
        return result;
    }

    private void setTableSegment(OpenGaussCommentStatement statement, Iterator<NameSegment> nameSegmentIterator) {
        Optional<NameSegment> tableName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        tableName.ifPresent(optional -> statement.setTable(new SimpleTableSegment(new TableNameSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier()))));
        Optional<NameSegment> schemaName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        schemaName.ifPresent(optional -> statement.getTable().setOwner(new OwnerSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier())));
        Optional<NameSegment> databaseName = nameSegmentIterator.hasNext() ? Optional.of(nameSegmentIterator.next()) : Optional.empty();
        databaseName.ifPresent(optional -> statement.getTable().getOwner().ifPresent(owner -> owner.setOwner(new OwnerSegment(optional.getStartIndex(), optional.getStopIndex(), optional.getIdentifier()))));
    }

    @Override
    public ASTNode visitCursor(OpenGaussStatementParser.CursorContext ctx) {
        OpenGaussCursorStatement result = new OpenGaussCursorStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitCursorName(OpenGaussStatementParser.CursorNameContext ctx) {
        return new CursorNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
    }

    @Override
    public ASTNode visitClose(OpenGaussStatementParser.CloseContext ctx) {
        OpenGaussCloseStatement result = new OpenGaussCloseStatement();
        if (null != ctx.cursorName()) {
            result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        }
        result.setCloseAll(null != ctx.ALL());
        return result;
    }

    @Override
    public ASTNode visitMove(OpenGaussStatementParser.MoveContext ctx) {
        OpenGaussMoveStatement result = new OpenGaussMoveStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        if (null != ctx.direction()) {
            result.setDirection((DirectionSegment)this.visit((ParseTree)ctx.direction()));
        }
        return result;
    }

    @Override
    public ASTNode visitFetch(OpenGaussStatementParser.FetchContext ctx) {
        OpenGaussFetchStatement result = new OpenGaussFetchStatement();
        result.setCursorName((CursorNameSegment)this.visit((ParseTree)ctx.cursorName()));
        if (null != ctx.direction()) {
            result.setDirection((DirectionSegment)this.visit((ParseTree)ctx.direction()));
        }
        return result;
    }

    @Override
    public ASTNode visitNext(OpenGaussStatementParser.NextContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.NEXT);
        return result;
    }

    @Override
    public ASTNode visitPrior(OpenGaussStatementParser.PriorContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.PRIOR);
        return result;
    }

    @Override
    public ASTNode visitFirst(OpenGaussStatementParser.FirstContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FIRST);
        return result;
    }

    @Override
    public ASTNode visitLast(OpenGaussStatementParser.LastContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.LAST);
        return result;
    }

    @Override
    public ASTNode visitAbsoluteCount(OpenGaussStatementParser.AbsoluteCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.ABSOLUTE_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitRelativeCount(OpenGaussStatementParser.RelativeCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.RELATIVE_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitCount(OpenGaussStatementParser.CountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitAll(OpenGaussStatementParser.AllContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.ALL);
        return result;
    }

    @Override
    public ASTNode visitForward(OpenGaussStatementParser.ForwardContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FORWARD);
        return result;
    }

    @Override
    public ASTNode visitForwardCount(OpenGaussStatementParser.ForwardCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FORWARD_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitForwardAll(OpenGaussStatementParser.ForwardAllContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.FORWARD_ALL);
        return result;
    }

    @Override
    public ASTNode visitBackward(OpenGaussStatementParser.BackwardContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.BACKWARD);
        return result;
    }

    @Override
    public ASTNode visitBackwardCount(OpenGaussStatementParser.BackwardCountContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.BACKWARD_COUNT);
        result.setCount(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.signedIconst())).getValue().longValue()));
        return result;
    }

    @Override
    public ASTNode visitBackwardAll(OpenGaussStatementParser.BackwardAllContext ctx) {
        DirectionSegment result = new DirectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setDirectionType(DirectionType.BACKWARD_ALL);
        return result;
    }

    @Generated
    public OpenGaussDDLStatementSQLVisitor() {
    }
}

