/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.filter.FilterableSchema;

public final class FilterableDatabase
extends AbstractSchema {
    private final String name;
    private final Map<String, Schema> subSchemaMap;

    public FilterableDatabase(ShardingSphereDatabase database, JavaTypeFactory javaTypeFactory, TableScanExecutor executor) {
        this.name = database.getName();
        this.subSchemaMap = this.createSubSchemaMap(database, javaTypeFactory, executor);
    }

    private Map<String, Schema> createSubSchemaMap(ShardingSphereDatabase database, JavaTypeFactory javaTypeFactory, TableScanExecutor executor) {
        LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>(database.getSchemas().size(), 1.0f);
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            result.put((String)entry.getKey(), (Schema)new FilterableSchema((String)entry.getKey(), (ShardingSphereSchema)entry.getValue(), database.getProtocolType(), javaTypeFactory, executor));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMap;
    }
}

