/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class CaseWhenExpressionConverter
implements SQLSegmentConverter<CaseWhenExpression, SqlNode> {
    @Override
    public Optional<SqlNode> convert(CaseWhenExpression segment) {
        Collection<SqlNode> whenExprs = this.convertWhenExprs(segment.getCaseExpr(), segment.getWhenExprs());
        LinkedList thenExprs = new LinkedList();
        segment.getThenExprs().forEach(each -> new ExpressionConverter().convert((ExpressionSegment)each).ifPresent(thenExprs::add));
        Optional<SqlNode> elseExpr = new ExpressionConverter().convert(segment.getElseExpr());
        return Optional.of(new SqlCase(SqlParserPos.ZERO, null, new SqlNodeList(whenExprs, SqlParserPos.ZERO), new SqlNodeList(thenExprs, SqlParserPos.ZERO), elseExpr.orElseGet(() -> SqlLiteral.createCharString((String)"NULL", (SqlParserPos)SqlParserPos.ZERO))));
    }

    private Collection<SqlNode> convertWhenExprs(ExpressionSegment caseExpr, Collection<ExpressionSegment> whenExprs) {
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        for (ExpressionSegment each : whenExprs) {
            if (null != caseExpr) {
                this.convertCaseExpr(caseExpr, each).ifPresent(result::add);
                continue;
            }
            new ExpressionConverter().convert(each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SqlNode> convertCaseExpr(ExpressionSegment caseExpr, ExpressionSegment whenExpr) {
        Optional<SqlNode> leftExpr = new ExpressionConverter().convert(caseExpr);
        Optional<SqlNode> rightExpr = new ExpressionConverter().convert(whenExpr);
        if (leftExpr.isPresent() && rightExpr.isPresent()) {
            return new ExpressionConverter().convert(whenExpr).map(optional -> new SqlBasicCall((SqlOperator)SqlStdOperatorTable.EQUALS, Arrays.asList((SqlNode)leftExpr.get(), (SqlNode)rightExpr.get()), SqlParserPos.ZERO));
        }
        return Optional.empty();
    }
}

