/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.math.BigDecimal;
import java.util.LinkedList;
import lombok.Generated;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Sarg;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.exception.OptimizationSQLRexNodeException;
import org.apache.shardingsphere.sqlfederation.optimizer.parser.rexnode.ParseRexNodeBaseVisitor;
import org.apache.shardingsphere.sqlfederation.optimizer.parser.rexnode.ParseRexNodeParser;

public final class ParseRexNodeVisitorImpl
extends ParseRexNodeBaseVisitor<RexNode> {
    private RexBuilder rexBuilder;
    private JavaTypeFactory typeFactory;

    @Override
    public RexNode visitExpression(ParseRexNodeParser.ExpressionContext ctx) {
        SqlOperator operator = this.getOp(ctx.op());
        RexNode firstNode = this.visitParameter(ctx.parameter(0));
        RexNode secondNode = this.visitParameter(ctx.parameter(1));
        return this.rexBuilder.makeCall(operator, new RexNode[]{firstNode, secondNode});
    }

    private SqlOperator getOp(ParseRexNodeParser.OpContext ctx) {
        if (null != ctx.LIKE()) {
            return SqlStdOperatorTable.LIKE;
        }
        if (null != ctx.SEARCH()) {
            return SqlStdOperatorTable.SEARCH;
        }
        if (null != ctx.AND()) {
            return SqlStdOperatorTable.AND;
        }
        if (null != ctx.OR()) {
            return SqlStdOperatorTable.OR;
        }
        if (null != ctx.NOT()) {
            return SqlStdOperatorTable.NOT;
        }
        if (null != ctx.EQ_()) {
            return SqlStdOperatorTable.EQUALS;
        }
        if (null != ctx.LT_()) {
            return SqlStdOperatorTable.LESS_THAN;
        }
        if (null != ctx.LTE_()) {
            return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
        }
        if (null != ctx.GT_()) {
            return SqlStdOperatorTable.GREATER_THAN;
        }
        if (null != ctx.GTE_()) {
            return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        }
        if (null != ctx.NEQ_()) {
            return SqlStdOperatorTable.NOT_EQUALS;
        }
        throw new OptimizationSQLRexNodeException(ctx.getText());
    }

    @Override
    public RexNode visitParameter(ParseRexNodeParser.ParameterContext ctx) {
        if (null != ctx.expression()) {
            return this.visitExpression(ctx.expression());
        }
        if (null != ctx.input()) {
            return this.visitInput(ctx.input());
        }
        throw new OptimizationSQLRexNodeException(ctx.getText());
    }

    @Override
    public RexNode visitInput(ParseRexNodeParser.InputContext ctx) {
        if (null != ctx.inputRef()) {
            return this.visitInputRef(ctx.inputRef());
        }
        if (null != ctx.searchArgs()) {
            return this.visitSearchArgs(ctx.searchArgs());
        }
        if (null != ctx.constant()) {
            return this.visitConstant(ctx.constant());
        }
        if (null != ctx.cast()) {
            return this.visitCast(ctx.cast());
        }
        if (null != ctx.paramWithType()) {
            return this.visitParamWithType(ctx.paramWithType());
        }
        throw new OptimizationSQLRexNodeException(ctx.getText());
    }

    @Override
    public RexNode visitInputRef(ParseRexNodeParser.InputRefContext ctx) {
        Integer index = Integer.valueOf(ctx.INTEGER_().getText());
        RelDataType nonNullableInt = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        return this.rexBuilder.makeInputRef(nonNullableInt, index.intValue());
    }

    @Override
    public RexNode visitSearchArgs(ParseRexNodeParser.SearchArgsContext ctx) {
        Sarg<BigDecimal> sarg;
        if (null != ctx.argList()) {
            sarg = this.getArgList(ctx.argList());
        } else if (null != ctx.argRange()) {
            sarg = this.getArgRange(ctx.argRange());
        } else if (null != ctx.argRangeList()) {
            sarg = this.getArgRangeList(ctx.argRangeList());
        } else {
            throw new OptimizationSQLRexNodeException(ctx.getText());
        }
        RelDataType sargType = this.typeFactory.createSqlType(SqlTypeName.DECIMAL);
        return this.rexBuilder.makeSearchArgumentLiteral(sarg, sargType);
    }

    @Override
    public RexNode visitConstant(ParseRexNodeParser.ConstantContext ctx) {
        if (null != ctx.INTEGER_()) {
            Integer number = Integer.valueOf(ctx.INTEGER_().getText());
            RelDataType nonNullableInt = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
            return this.rexBuilder.makeLiteral((Object)number, nonNullableInt, false);
        }
        if (null != ctx.STRING_()) {
            RelDataType varchar = this.typeFactory.createSqlType(SqlTypeName.VARCHAR);
            return this.rexBuilder.makeLiteral((Object)ctx.STRING_().getText(), varchar, false);
        }
        throw new OptimizationSQLRexNodeException(ctx.getText());
    }

    @Override
    public RexNode visitCast(ParseRexNodeParser.CastContext ctx) {
        RexNode inputRef = this.visitInputRef(ctx.inputRef());
        RelDataType type = this.getType(ctx.type());
        return this.rexBuilder.makeCast(type, inputRef);
    }

    @Override
    public RexNode visitParamWithType(ParseRexNodeParser.ParamWithTypeContext ctx) {
        RelDataType type = this.getType(ctx.type());
        return null == ctx.INTEGER_() ? this.rexBuilder.makeLiteral((Object)ctx.STRING_().getText(), type) : this.rexBuilder.makeLiteral((Object)Integer.valueOf(ctx.INTEGER_().getText()), type);
    }

    private Sarg<BigDecimal> getArgRange(ParseRexNodeParser.ArgRangeContext ctx) {
        BigDecimal lowerValue = BigDecimal.valueOf(Long.parseLong(ctx.INTEGER_(0).getText()));
        BigDecimal upperValue = BigDecimal.valueOf(Long.parseLong(ctx.INTEGER_(1).getText()));
        Range.range((Comparable)lowerValue, (BoundType)BoundType.OPEN, (Comparable)upperValue, (BoundType)BoundType.OPEN);
        return null == ctx.LP_() ? Sarg.of((RexUnknownAs)RexUnknownAs.UNKNOWN, (RangeSet)ImmutableRangeSet.of((Range)Range.range((Comparable)lowerValue, (BoundType)BoundType.CLOSED, (Comparable)upperValue, (BoundType)BoundType.CLOSED))) : Sarg.of((RexUnknownAs)RexUnknownAs.UNKNOWN, (RangeSet)ImmutableRangeSet.of((Range)Range.range((Comparable)lowerValue, (BoundType)BoundType.OPEN, (Comparable)upperValue, (BoundType)BoundType.OPEN)));
    }

    private Sarg<BigDecimal> getArgList(ParseRexNodeParser.ArgListContext ctx) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        for (TerminalNode each : ctx.INTEGER_()) {
            BigDecimal value = BigDecimal.valueOf(Long.parseLong(each.getText()));
            rangeSet.add(Range.singleton((Comparable)value));
        }
        return Sarg.of((RexUnknownAs)RexUnknownAs.UNKNOWN, (RangeSet)rangeSet);
    }

    private Sarg<BigDecimal> getArgRangeList(ParseRexNodeParser.ArgRangeListContext ctx) {
        LinkedList<Range> rangeList = new LinkedList<Range>();
        for (ParseRexNodeParser.ArgRangeContext each : ctx.argRange()) {
            Range range;
            String lower;
            BigDecimal lowerValue = BigDecimal.valueOf(Long.MIN_VALUE);
            BigDecimal upperValue = BigDecimal.valueOf(Long.MAX_VALUE);
            if (null != each.NEGETIVE_INFINITY_() && null != each.INTEGER_(0)) {
                String upper = each.INTEGER_(0).getText();
                upperValue = BigDecimal.valueOf(Long.parseLong(upper));
            }
            if (null != each.POSITIVE_INFINITY_() && null != each.INTEGER_(0)) {
                lower = each.INTEGER_(0).getText();
                lowerValue = BigDecimal.valueOf(Long.parseLong(lower));
            }
            if (null == each.NEGETIVE_INFINITY_() && null == each.POSITIVE_INFINITY_()) {
                lower = each.INTEGER_(0).getText();
                String upper = each.INTEGER_(1).getText();
                lowerValue = BigDecimal.valueOf(Long.parseLong(lower));
                upperValue = BigDecimal.valueOf(Long.parseLong(upper));
            }
            if (null == each.LP_()) {
                range = Range.range((Comparable)lowerValue, (BoundType)BoundType.CLOSED, (Comparable)upperValue, (BoundType)BoundType.CLOSED);
                rangeList.add(range);
                continue;
            }
            range = Range.range((Comparable)lowerValue, (BoundType)BoundType.OPEN, (Comparable)upperValue, (BoundType)BoundType.OPEN);
            rangeList.add(range);
        }
        return Sarg.of((RexUnknownAs)RexUnknownAs.UNKNOWN, (RangeSet)ImmutableRangeSet.copyOf(rangeList));
    }

    private RelDataType getType(ParseRexNodeParser.TypeContext ctx) {
        return null == ctx.INTEGER() ? this.typeFactory.createSqlType(SqlTypeName.VARCHAR) : this.typeFactory.createSqlType(SqlTypeName.INTEGER);
    }

    @Generated
    public ParseRexNodeVisitorImpl(RexBuilder rexBuilder, JavaTypeFactory typeFactory) {
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
    }
}

