/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.keygen;

import java.util.Calendar;
import java.util.Properties;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.snowflake.ClockSyncSnowflakeId;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.StringSnowflakeId;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.InstanceContextAware;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.exception.ShardingPluginException;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;

public final class CosIdSnowflakeKeyGenerateAlgorithm
implements KeyGenerateAlgorithm,
InstanceContextAware {
    public static final long DEFAULT_EPOCH;
    public static final String AS_STRING_KEY = "as-string";
    public static final String EPOCH_KEY = "epoch";
    private Properties props;
    private SnowflakeId snowflakeId;
    private boolean asString;
    private long epoch;

    public void init(Properties props) {
        this.props = props;
        this.asString = this.getAsString(props);
        this.epoch = this.getEpoch(props);
    }

    private boolean getAsString(Properties props) {
        return Boolean.parseBoolean(props.getProperty(AS_STRING_KEY, Boolean.FALSE.toString()));
    }

    private long getEpoch(Properties props) {
        return Long.parseLong(props.getProperty(EPOCH_KEY, DEFAULT_EPOCH + ""));
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        int workerId = instanceContext.generateWorkerId(this.props);
        MillisecondSnowflakeId millisecondSnowflakeId = new MillisecondSnowflakeId(this.epoch, 41, 10, 12, workerId);
        this.snowflakeId = new StringSnowflakeId((SnowflakeId)new ClockSyncSnowflakeId((SnowflakeId)millisecondSnowflakeId), (IdConverter)Radix62IdConverter.PAD_START);
    }

    public Comparable<?> generateKey() {
        if (this.asString) {
            return this.getSnowflakeId().generateAsString();
        }
        return this.getSnowflakeId().generate();
    }

    private SnowflakeId getSnowflakeId() {
        ShardingSpherePreconditions.checkNotNull((Object)this.snowflakeId, () -> new ShardingPluginException("Instance context not set yet.", new Object[0]));
        return this.snowflakeId;
    }

    public String getType() {
        return "COSID_SNOWFLAKE";
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 10, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        DEFAULT_EPOCH = calendar.getTimeInMillis();
    }
}

