/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.cache.checker.ShardingRouteCacheableCheckResult;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCacheKey;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCacheValue;
import org.apache.shardingsphere.sharding.cache.rule.ShardingCacheRule;
import org.apache.shardingsphere.sharding.route.engine.ShardingSQLRouter;

public final class CachedShardingSQLRouter
implements SQLRouter<ShardingCacheRule> {
    public RouteContext createRouteContext(QueryContext queryContext, ShardingSphereDatabase database, ShardingCacheRule rule, ConfigurationProperties props, ConnectionContext connectionContext) {
        if (queryContext.getSql().length() > rule.getConfiguration().getAllowedMaxSqlLength()) {
            return new RouteContext();
        }
        ShardingRouteCacheableCheckResult cacheableCheckResult = rule.getRouteCacheableChecker().check(database, queryContext);
        if (!cacheableCheckResult.isProbablyCacheable()) {
            return new RouteContext();
        }
        ArrayList<Object> shardingConditionParameters = new ArrayList<Object>(cacheableCheckResult.getShardingConditionParameterMarkerIndexes().size());
        for (int each : cacheableCheckResult.getShardingConditionParameterMarkerIndexes()) {
            if (each >= queryContext.getParameters().size()) {
                return new RouteContext();
            }
            shardingConditionParameters.add(queryContext.getParameters().get(each));
        }
        Optional cachedRouteContext = rule.getRouteCache().get(new ShardingRouteCacheKey(queryContext.getSql(), shardingConditionParameters)).flatMap(ShardingRouteCacheValue::getCachedRouteContext);
        RouteContext result = cachedRouteContext.orElseGet(() -> new ShardingSQLRouter().createRouteContext(queryContext, database, rule.getShardingRule(), props, connectionContext));
        if (!cachedRouteContext.isPresent() && this.hitOneShardOnly(result)) {
            rule.getRouteCache().put(new ShardingRouteCacheKey(queryContext.getSql(), shardingConditionParameters), new ShardingRouteCacheValue(result));
        }
        return result;
    }

    private boolean hitOneShardOnly(RouteContext routeContext) {
        return 1 == routeContext.getRouteUnits().size() && 1 == ((RouteUnit)routeContext.getRouteUnits().iterator().next()).getTableMappers().size() && 1 == routeContext.getOriginalDataNodes().size() && 1 == ((Collection)routeContext.getOriginalDataNodes().iterator().next()).size();
    }

    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, ShardingCacheRule rule, ConfigurationProperties props, ConnectionContext connectionContext) {
    }

    public int getOrder() {
        return -11;
    }

    public Class<ShardingCacheRule> getTypeClass() {
        return ShardingCacheRule.class;
    }
}

