/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dialect.postgresql.message;

import lombok.Generated;
import org.apache.shardingsphere.infra.util.exception.external.sql.vendor.VendorError;
import org.postgresql.util.ServerErrorMessage;

public final class ServerErrorMessageBuilder {
    public static ServerErrorMessage build(String severity, VendorError vendorError, Object ... reasonArgs) {
        return new ServerErrorMessage(String.join((CharSequence)"\u0000", ServerErrorMessageBuilder.buildSeverity(severity), ServerErrorMessageBuilder.buildNewSeverity(severity), ServerErrorMessageBuilder.buildSQLState(vendorError), ServerErrorMessageBuilder.buildReason(String.format(vendorError.getReason(), reasonArgs))));
    }

    private static String buildSeverity(String severity) {
        return 'S' + severity;
    }

    private static String buildNewSeverity(String severity) {
        return 'V' + severity;
    }

    private static String buildSQLState(VendorError vendorError) {
        return 'C' + vendorError.getSqlState().getValue();
    }

    private static String buildReason(String reason) {
        return 'M' + reason;
    }

    @Generated
    private ServerErrorMessageBuilder() {
    }
}

