/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.parser.spring.boot;

import lombok.RequiredArgsConstructor;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.parser.spring.boot.condition.SQLParserSpringBootCondition;
import org.apache.shardingsphere.parser.spring.boot.rule.YamlSQLParserRuleSpringBootConfiguration;
import org.apache.shardingsphere.parser.yaml.config.YamlSQLParserRuleConfiguration;
import org.apache.shardingsphere.parser.yaml.swapper.YamlSQLParserRuleConfigurationSwapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

/**
 * SQL parser rule configuration for spring boot.
 */
@Configuration
@EnableConfigurationProperties(YamlSQLParserRuleSpringBootConfiguration.class)
@ConditionalOnClass(YamlSQLParserRuleConfiguration.class)
@Conditional(SQLParserSpringBootCondition.class)
@RequiredArgsConstructor
public class SQLParserRuleSpringBootConfiguration {
    
    private final YamlSQLParserRuleConfigurationSwapper swapper = new YamlSQLParserRuleConfigurationSwapper();
    
    private final YamlSQLParserRuleSpringBootConfiguration yamlConfig;
    
    /**
     * Create SQL parser rule configuration bean.
     *
     * @return SQL parser rule configuration
     */
    @Bean
    public RuleConfiguration sqlParserRuleConfiguration() {
        return swapper.swapToObject(yamlConfig.getSqlParser());
    }
}
