/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dialect.mysql.mapper;

import java.sql.SQLException;
import org.apache.shardingsphere.dialect.exception.SQLDialectException;
import org.apache.shardingsphere.dialect.exception.connection.TooManyConnectionsException;
import org.apache.shardingsphere.dialect.exception.data.InsertColumnsAndValuesMismatchedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.DatabaseCreateExistsException;
import org.apache.shardingsphere.dialect.exception.syntax.database.DatabaseDropNotExistsException;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.dialect.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.dialect.exception.transaction.TableModifyInTransactionException;
import org.apache.shardingsphere.dialect.mapper.SQLDialectExceptionMapper;
import org.apache.shardingsphere.dialect.mysql.exception.UnknownCharsetException;
import org.apache.shardingsphere.dialect.mysql.exception.UnknownCollationException;
import org.apache.shardingsphere.dialect.mysql.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.dialect.mysql.vendor.MySQLVendorError;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnknownSQLException;
import org.apache.shardingsphere.infra.util.exception.external.sql.vendor.VendorError;

public final class MySQLDialectExceptionMapper
implements SQLDialectExceptionMapper {
    public SQLException convert(SQLDialectException sqlDialectException) {
        if (sqlDialectException instanceof UnknownDatabaseException) {
            return null != ((UnknownDatabaseException)sqlDialectException).getDatabaseName() ? this.toSQLException(MySQLVendorError.ER_BAD_DB_ERROR, ((UnknownDatabaseException)sqlDialectException).getDatabaseName()) : this.toSQLException(MySQLVendorError.ER_NO_DB_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof NoDatabaseSelectedException) {
            return this.toSQLException(MySQLVendorError.ER_NO_DB_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof DatabaseCreateExistsException) {
            return this.toSQLException(MySQLVendorError.ER_DB_CREATE_EXISTS_ERROR, ((DatabaseCreateExistsException)sqlDialectException).getDatabaseName());
        }
        if (sqlDialectException instanceof DatabaseDropNotExistsException) {
            return this.toSQLException(MySQLVendorError.ER_DB_DROP_NOT_EXISTS_ERROR, ((DatabaseDropNotExistsException)sqlDialectException).getDatabaseName());
        }
        if (sqlDialectException instanceof TableExistsException) {
            return this.toSQLException(MySQLVendorError.ER_TABLE_EXISTS_ERROR, ((TableExistsException)sqlDialectException).getTableName());
        }
        if (sqlDialectException instanceof NoSuchTableException) {
            return this.toSQLException(MySQLVendorError.ER_NO_SUCH_TABLE, ((NoSuchTableException)sqlDialectException).getTableName());
        }
        if (sqlDialectException instanceof InsertColumnsAndValuesMismatchedException) {
            return this.toSQLException(MySQLVendorError.ER_WRONG_VALUE_COUNT_ON_ROW, ((InsertColumnsAndValuesMismatchedException)sqlDialectException).getMismatchedRowNumber());
        }
        if (sqlDialectException instanceof TableModifyInTransactionException) {
            return this.toSQLException(MySQLVendorError.ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE, ((TableModifyInTransactionException)sqlDialectException).getTableName());
        }
        if (sqlDialectException instanceof TooManyConnectionsException) {
            return this.toSQLException(MySQLVendorError.ER_CON_COUNT_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof UnsupportedPreparedStatementException) {
            return this.toSQLException(MySQLVendorError.ER_UNSUPPORTED_PS, new Object[0]);
        }
        if (sqlDialectException instanceof UnknownCharsetException) {
            return this.toSQLException(MySQLVendorError.ER_UNKNOWN_CHARACTER_SET, ((UnknownCharsetException)sqlDialectException).getCharset());
        }
        if (sqlDialectException instanceof UnknownCollationException) {
            return this.toSQLException(MySQLVendorError.ER_UNKNOWN_COLLATION, ((UnknownCollationException)sqlDialectException).getCollationId());
        }
        return new UnknownSQLException((Exception)sqlDialectException).toSQLException();
    }

    private SQLException toSQLException(VendorError vendorError, Object ... messageArgs) {
        return new SQLException(String.format(vendorError.getReason(), messageArgs), vendorError.getSqlState().getValue(), vendorError.getVendorCode());
    }

    public String getType() {
        return "MySQL";
    }
}

