/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.metadata.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.refresher.FederationMetaDataRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableFederationMetaDataRefresher
implements FederationMetaDataRefresher<AlterTableStatement> {
    @Override
    public void refresh(FederationSchemaMetaData schema, Collection<String> logicDataSourceNames, AlterTableStatement sqlStatement, SchemaBuilderMaterials materials) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        if (sqlStatement.getRenameTable().isPresent()) {
            String renameTableName = ((SimpleTableSegment)sqlStatement.getRenameTable().get()).getTableName().getIdentifier().getValue();
            this.buildTableMetaData(materials, renameTableName).ifPresent(schema::update);
            schema.remove(tableName);
        } else {
            this.buildTableMetaData(materials, tableName).ifPresent(schema::update);
        }
    }

    private Optional<TableMetaData> buildTableMetaData(SchemaBuilderMaterials materials, String tableName) throws SQLException {
        return Optional.ofNullable(TableMetaDataBuilder.load(Collections.singletonList(tableName), (SchemaBuilderMaterials)materials).get(tableName)).map(each -> TableMetaDataBuilder.decorateFederationTableMetaData((TableMetaData)each, (Collection)materials.getRules()));
    }
}

