/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.expression.impl;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnConverter
implements SQLSegmentConverter<ColumnSegment, SqlIdentifier> {
    @Override
    public Optional<SqlIdentifier> convertToSQLNode(ColumnSegment segment) {
        Optional owner = segment.getOwner();
        String columnName = segment.getIdentifier().getValue();
        SqlIdentifier sqlIdentifier = owner.map(optional -> new SqlIdentifier(Arrays.asList(optional.getIdentifier().getValue(), columnName), SqlParserPos.ZERO)).orElseGet(() -> new SqlIdentifier(columnName, SqlParserPos.ZERO));
        return Optional.of(sqlIdentifier);
    }

    @Override
    public Optional<ColumnSegment> convertToSQLSegment(SqlIdentifier sqlIdentifier) {
        if (null == sqlIdentifier) {
            return Optional.empty();
        }
        ImmutableList names = sqlIdentifier.names;
        if (1 == names.size()) {
            return Optional.of(new ColumnSegment(this.getStartIndex((SqlNode)sqlIdentifier), this.getStopIndex((SqlNode)sqlIdentifier), new IdentifierValue((String)names.get(0))));
        }
        ColumnSegment result = new ColumnSegment(this.getStartIndex((SqlNode)sqlIdentifier), this.getStopIndex((SqlNode)sqlIdentifier), new IdentifierValue((String)names.get(1)));
        SqlIdentifier owner = sqlIdentifier.getComponent(0);
        result.setOwner(new OwnerSegment(this.getStartIndex((SqlNode)owner), this.getStopIndex((SqlNode)owner), new IdentifierValue((String)names.get(0))));
        return Optional.of(result);
    }
}

