/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata.filter;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.shardingsphere.infra.federation.optimizer.executor.FilterableScanNodeExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.statistic.FederationStatistic;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class FilterableTable
extends AbstractTable
implements ProjectableFilterableTable {
    private final ShardingSphereTable table;
    private final TableScanExecutor executor;
    private final FederationStatistic statistic;

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.createRelDataType(this.table, typeFactory);
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, int[] projects) {
        return this.executor.execute(this.table, new FilterableScanNodeExecutorContext(root, filters, projects));
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    private RelDataType createRelDataType(ShardingSphereTable table, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        for (ShardingSphereColumn each : table.getColumns().values()) {
            fieldInfoBuilder.add(each.getName(), this.getRelDataType(each, typeFactory));
        }
        return fieldInfoBuilder.build();
    }

    private RelDataType getRelDataType(ShardingSphereColumn column, RelDataTypeFactory typeFactory) {
        Class sqlTypeClass = SqlType.valueOf((int)column.getDataType()).clazz;
        RelDataType javaType = typeFactory.createJavaType(sqlTypeClass);
        return typeFactory.createTypeWithNullability(javaType, true);
    }

    @Generated
    public FilterableTable(ShardingSphereTable table, TableScanExecutor executor, FederationStatistic statistic) {
        this.table = table;
        this.executor = executor;
        this.statistic = statistic;
    }
}

