/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.loader;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.loader.JDBCRowsLoader;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;

public abstract class AbstractJDBCRowsLoader
implements JDBCRowsLoader {
    @Override
    public Collection<MemoryQueryResultDataRow> load(int columnCount, ResultSet resultSet) throws SQLException {
        LinkedList<MemoryQueryResultDataRow> result = new LinkedList<MemoryQueryResultDataRow>();
        while (resultSet.next()) {
            ArrayList<Object> rowData = new ArrayList<Object>(columnCount);
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                Object rowValue = this.loadRowValue(resultSet, columnIndex);
                rowData.add(resultSet.wasNull() ? null : rowValue);
            }
            result.add(new MemoryQueryResultDataRow(rowData));
        }
        return result;
    }

    private Object loadRowValue(ResultSet resultSet, int columnIndex) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        switch (metaData.getColumnType(columnIndex)) {
            case 16: {
                return resultSet.getBoolean(columnIndex);
            }
            case -6: 
            case 5: {
                return resultSet.getInt(columnIndex);
            }
            case 4: {
                if (metaData.isSigned(columnIndex)) {
                    return resultSet.getInt(columnIndex);
                }
                return resultSet.getLong(columnIndex);
            }
            case -5: {
                if (metaData.isSigned(columnIndex)) {
                    return resultSet.getLong(columnIndex);
                }
                BigDecimal bigDecimal = resultSet.getBigDecimal(columnIndex);
                return null == bigDecimal ? null : bigDecimal.toBigInteger();
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(columnIndex);
            }
            case 6: 
            case 8: {
                return resultSet.getDouble(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(columnIndex);
            }
            case 91: {
                return this.getDate(resultSet, columnIndex);
            }
            case 92: {
                return resultSet.getTime(columnIndex);
            }
            case 93: {
                return resultSet.getTimestamp(columnIndex);
            }
            case 2005: {
                return resultSet.getClob(columnIndex);
            }
            case 2004: {
                return resultSet.getBlob(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return resultSet.getBytes(columnIndex);
            }
            case 2003: {
                return resultSet.getArray(columnIndex);
            }
        }
        return resultSet.getObject(columnIndex);
    }

    protected abstract Object getDate(ResultSet var1, int var2) throws SQLException;
}

