/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class AlterIndexStatementSchemaRefresher
implements MetaDataRefresher<AlterIndexStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, AlterIndexStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional renameIndex = AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)sqlStatement);
        if (!sqlStatement.getIndex().isPresent() || !renameIndex.isPresent()) {
            return Optional.empty();
        }
        String actualSchemaName = ((IndexSegment)sqlStatement.getIndex().get()).getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
        String indexName = ((IndexSegment)sqlStatement.getIndex().get()).getIndexName().getIdentifier().getValue();
        Optional<String> logicTableName = this.findLogicTableName(database.getSchema(actualSchemaName), indexName);
        if (logicTableName.isPresent()) {
            ShardingSphereTable table = database.getSchema(actualSchemaName).get(logicTableName.get());
            Preconditions.checkNotNull((Object)table, (String)"Can not get the table '%s' metadata!", (Object)logicTableName.get());
            table.getIndexes().remove(indexName);
            String renameIndexName = ((IndexSegment)renameIndex.get()).getIndexName().getIdentifier().getValue();
            table.getIndexes().put(renameIndexName, new ShardingSphereIndex(renameIndexName));
            SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), actualSchemaName);
            event.getAlteredTables().add(table);
            return Optional.of(event);
        }
        return Optional.empty();
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String indexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.get(each).getIndexes().containsKey(indexName)).findFirst();
    }

    public String getType() {
        return AlterIndexStatement.class.getName();
    }
}

