/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;

public final class ShardingSphereTable {
    private final String name;
    private final Map<String, ShardingSphereColumn> columns;
    private final Map<String, ShardingSphereIndex> indexes;
    private final Map<String, ShardingSphereConstraint> constrains;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> visibleColumns = new ArrayList<String>();
    private final List<String> primaryKeyColumns = new ArrayList<String>();

    public ShardingSphereTable() {
        this("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public ShardingSphereTable(String name, Collection<ShardingSphereColumn> columnList, Collection<ShardingSphereIndex> indexList, Collection<ShardingSphereConstraint> constraintList) {
        this.name = name;
        this.columns = this.getColumns(columnList);
        this.indexes = this.getIndexes(indexList);
        this.constrains = this.getConstrains(constraintList);
    }

    private Map<String, ShardingSphereColumn> getColumns(Collection<ShardingSphereColumn> columnList) {
        LinkedHashMap<String, ShardingSphereColumn> result = new LinkedHashMap<String, ShardingSphereColumn>(columnList.size(), 1.0f);
        for (ShardingSphereColumn each : columnList) {
            String lowerColumnName = each.getName().toLowerCase();
            result.put(lowerColumnName, each);
            this.columnNames.add(each.getName());
            if (each.isPrimaryKey()) {
                this.primaryKeyColumns.add(lowerColumnName);
            }
            if (!each.isVisible()) continue;
            this.visibleColumns.add(each.getName());
        }
        return result;
    }

    private Map<String, ShardingSphereIndex> getIndexes(Collection<ShardingSphereIndex> indexList) {
        LinkedHashMap<String, ShardingSphereIndex> result = new LinkedHashMap<String, ShardingSphereIndex>(indexList.size(), 1.0f);
        for (ShardingSphereIndex each : indexList) {
            result.put(each.getName().toLowerCase(), each);
        }
        return result;
    }

    private Map<String, ShardingSphereConstraint> getConstrains(Collection<ShardingSphereConstraint> constraintList) {
        LinkedHashMap<String, ShardingSphereConstraint> result = new LinkedHashMap<String, ShardingSphereConstraint>(constraintList.size(), 1.0f);
        for (ShardingSphereConstraint each : constraintList) {
            result.put(each.getName().toLowerCase(), each);
        }
        return result;
    }

    @Generated
    public ShardingSphereTable(String name, Map<String, ShardingSphereColumn> columns, Map<String, ShardingSphereIndex> indexes, Map<String, ShardingSphereConstraint> constrains) {
        this.name = name;
        this.columns = columns;
        this.indexes = indexes;
        this.constrains = constrains;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, ShardingSphereColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, ShardingSphereIndex> getIndexes() {
        return this.indexes;
    }

    @Generated
    public Map<String, ShardingSphereConstraint> getConstrains() {
        return this.constrains;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardingSphereTable)) {
            return false;
        }
        ShardingSphereTable other = (ShardingSphereTable)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, ShardingSphereColumn> this$columns = this.getColumns();
        Map<String, ShardingSphereColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, ShardingSphereIndex> this$indexes = this.getIndexes();
        Map<String, ShardingSphereIndex> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        Map<String, ShardingSphereConstraint> this$constrains = this.getConstrains();
        Map<String, ShardingSphereConstraint> other$constrains = other.getConstrains();
        if (this$constrains == null ? other$constrains != null : !((Object)this$constrains).equals(other$constrains)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<String> this$visibleColumns = this.getVisibleColumns();
        List<String> other$visibleColumns = other.getVisibleColumns();
        if (this$visibleColumns == null ? other$visibleColumns != null : !((Object)this$visibleColumns).equals(other$visibleColumns)) {
            return false;
        }
        List<String> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<String> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        return !(this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, ShardingSphereColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, ShardingSphereIndex> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        Map<String, ShardingSphereConstraint> $constrains = this.getConstrains();
        result = result * 59 + ($constrains == null ? 43 : ((Object)$constrains).hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<String> $visibleColumns = this.getVisibleColumns();
        result = result * 59 + ($visibleColumns == null ? 43 : ((Object)$visibleColumns).hashCode());
        List<String> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShardingSphereTable(name=" + this.getName() + ", columns=" + this.getColumns() + ", indexes=" + this.getIndexes() + ", constrains=" + this.getConstrains() + ", columnNames=" + this.getColumnNames() + ", visibleColumns=" + this.getVisibleColumns() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ")";
    }
}

