/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.metadata;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.common.TableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.metadata.DialectSchemaMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.metadata.SchemaMetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnknownSQLException;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaMetaDataLoaderEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaMetaDataLoaderEngine.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShardingSphere-SchemaMetaDataLoaderEngine-%d").build());

    public static Map<String, SchemaMetaData> load(Collection<SchemaMetaDataLoaderMaterial> materials) throws SQLException {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>(materials.size(), 1.0f);
        LinkedList<Future<Collection>> futures = new LinkedList<Future<Collection>>();
        for (SchemaMetaDataLoaderMaterial schemaMetaDataLoaderMaterial : materials) {
            futures.add(EXECUTOR_SERVICE.submit(() -> SchemaMetaDataLoaderEngine.load(schemaMetaDataLoaderMaterial)));
        }
        try {
            for (Future future : futures) {
                SchemaMetaDataLoaderEngine.mergeSchemaMetaDataMap(result, (Collection)future.get());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw new UnknownSQLException(ex).toSQLException();
        }
        return result;
    }

    private static Collection<SchemaMetaData> load(SchemaMetaDataLoaderMaterial material) throws SQLException {
        Optional dialectSchemaMetaDataLoader = TypedSPILoader.findService(DialectSchemaMetaDataLoader.class, (String)material.getStorageType().getType());
        if (dialectSchemaMetaDataLoader.isPresent()) {
            try {
                return ((DialectSchemaMetaDataLoader)dialectSchemaMetaDataLoader.get()).load(material.getDataSource(), material.getActualTableNames(), material.getDefaultSchemaName());
            }
            catch (Exception ex) {
                log.debug("Dialect load schema meta data error.", (Throwable)ex);
            }
        }
        return SchemaMetaDataLoaderEngine.loadByDefault(material);
    }

    private static Collection<SchemaMetaData> loadByDefault(SchemaMetaDataLoaderMaterial material) throws SQLException {
        LinkedList<TableMetaData> tableMetaData = new LinkedList<TableMetaData>();
        for (String each : material.getActualTableNames()) {
            TableMetaDataLoader.load(material.getDataSource(), each, material.getStorageType()).ifPresent(tableMetaData::add);
        }
        return Collections.singletonList(new SchemaMetaData(material.getDefaultSchemaName(), tableMetaData));
    }

    private static void mergeSchemaMetaDataMap(Map<String, SchemaMetaData> schemaMetaDataMap, Collection<SchemaMetaData> addedSchemaMetaDataList) {
        for (SchemaMetaData each : addedSchemaMetaDataList) {
            SchemaMetaData schemaMetaData = schemaMetaDataMap.computeIfAbsent(each.getName(), key -> new SchemaMetaData(each.getName(), new LinkedList<TableMetaData>()));
            schemaMetaData.getTables().addAll(each.getTables());
        }
    }

    @Generated
    private SchemaMetaDataLoaderEngine() {
    }
}

