/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.state.instance.InstanceStateContext;

public final class ComputeNodeInstance {
    private final InstanceMetaData metaData;
    private final InstanceStateContext state = new InstanceStateContext();
    private Collection<String> labels = new LinkedList<String>();
    private volatile int workerId;

    public ComputeNodeInstance(InstanceMetaData metaData) {
        this.metaData = metaData;
        this.workerId = -1;
    }

    public void setLabels(Collection<String> labels) {
        if (null != labels) {
            this.labels = labels;
        }
    }

    public void switchState(String status) {
        this.state.switchState(InstanceState.CIRCUIT_BREAK, InstanceState.CIRCUIT_BREAK.name().equals(status));
    }

    public String getCurrentInstanceId() {
        return this.metaData.getId();
    }

    @Generated
    public InstanceMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public InstanceStateContext getState() {
        return this.state;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    @Generated
    public int getWorkerId() {
        return this.workerId;
    }

    @Generated
    public void setWorkerId(int workerId) {
        this.workerId = workerId;
    }
}

