/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.creator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourceReflection;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaDataReflection;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.custom.CustomDataSourceProperties;
import org.apache.shardingsphere.infra.datasource.registry.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolCreator {
    public static Map<String, DataSource> create(Map<String, DataSourceProperties> dataSourcePropsMap) {
        return DataSourcePoolCreator.create(dataSourcePropsMap, true);
    }

    public static Map<String, DataSource> create(Map<String, DataSourceProperties> dataSourcePropsMap, boolean cacheEnabled) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropsMap.entrySet()) {
            DataSource dataSource;
            try {
                dataSource = DataSourcePoolCreator.create(entry.getKey(), entry.getValue(), cacheEnabled);
            }
            catch (Exception ex) {
                if (!cacheEnabled) {
                    result.values().stream().map(DataSourcePoolDestroyer::new).forEach(DataSourcePoolDestroyer::asyncDestroy);
                }
                throw ex;
            }
            result.put(entry.getKey(), dataSource);
        }
        return result;
    }

    public static DataSource create(DataSourceProperties dataSourceProps) {
        DataSource result = DataSourcePoolCreator.createDataSource(dataSourceProps.getDataSourceClassName());
        Optional poolMetaData = TypedSPILoader.findService(DataSourcePoolMetaData.class, (String)dataSourceProps.getDataSourceClassName());
        DataSourceReflection dataSourceReflection = new DataSourceReflection(result);
        if (poolMetaData.isPresent()) {
            DataSourcePoolCreator.setDefaultFields(dataSourceReflection, (DataSourcePoolMetaData)poolMetaData.get());
            DataSourcePoolCreator.setConfiguredFields(dataSourceProps, dataSourceReflection, (DataSourcePoolMetaData)poolMetaData.get());
            DataSourcePoolCreator.appendJdbcUrlProperties(dataSourceProps.getCustomDataSourceProperties(), result, (DataSourcePoolMetaData)poolMetaData.get());
            dataSourceReflection.addDefaultDataSourceProperties();
        } else {
            DataSourcePoolCreator.setConfiguredFields(dataSourceProps, dataSourceReflection);
        }
        return result;
    }

    public static DataSource create(String dataSourceName, DataSourceProperties dataSourceProps, boolean cacheEnabled) {
        DataSource result = DataSourcePoolCreator.create(dataSourceProps);
        if (cacheEnabled && !GlobalDataSourceRegistry.getInstance().getCachedDataSourceDataSources().containsKey(dataSourceName)) {
            GlobalDataSourceRegistry.getInstance().getCachedDataSourceDataSources().put(dataSourceName, result);
        }
        return result;
    }

    private static DataSource createDataSource(String dataSourceClassName) {
        return (DataSource)Class.forName(dataSourceClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static void setDefaultFields(DataSourceReflection dataSourceReflection, DataSourcePoolMetaData poolMetaData) {
        for (Map.Entry<String, Object> entry : poolMetaData.getDefaultProperties().entrySet()) {
            dataSourceReflection.setField(entry.getKey(), entry.getValue());
        }
    }

    private static void setConfiguredFields(DataSourceProperties dataSourceProps, DataSourceReflection dataSourceReflection) {
        for (Map.Entry<String, Object> entry : dataSourceProps.getAllLocalProperties().entrySet()) {
            dataSourceReflection.setField(entry.getKey(), entry.getValue());
        }
    }

    private static void setConfiguredFields(DataSourceProperties dataSourceProps, DataSourceReflection dataSourceReflection, DataSourcePoolMetaData poolMetaData) {
        for (Map.Entry<String, Object> entry : dataSourceProps.getAllLocalProperties().entrySet()) {
            Object fieldValue;
            String fieldName = entry.getKey();
            if (!DataSourcePoolCreator.isValidProperty(fieldName, fieldValue = entry.getValue(), poolMetaData) || fieldName.equals(poolMetaData.getFieldMetaData().getJdbcUrlPropertiesFieldName())) continue;
            dataSourceReflection.setField(fieldName, fieldValue);
        }
    }

    private static boolean isValidProperty(String key, Object value, DataSourcePoolMetaData poolMetaData) {
        return !poolMetaData.getInvalidProperties().containsKey(key) || null == value || !value.equals(poolMetaData.getInvalidProperties().get(key));
    }

    private static void appendJdbcUrlProperties(CustomDataSourceProperties customDataSourceProps, DataSource targetDataSource, DataSourcePoolMetaData poolMetaData) {
        String jdbcUrlPropertiesFieldName = poolMetaData.getFieldMetaData().getJdbcUrlPropertiesFieldName();
        if (null != jdbcUrlPropertiesFieldName && customDataSourceProps.getProperties().containsKey(jdbcUrlPropertiesFieldName)) {
            Map jdbcUrlProps = (Map)customDataSourceProps.getProperties().get(jdbcUrlPropertiesFieldName);
            DataSourcePoolMetaDataReflection dataSourcePoolMetaDataReflection = new DataSourcePoolMetaDataReflection(targetDataSource, poolMetaData.getFieldMetaData());
            for (Map.Entry entry : jdbcUrlProps.entrySet()) {
                dataSourcePoolMetaDataReflection.getJdbcConnectionProperties().ifPresent(optional -> optional.setProperty((String)entry.getKey(), entry.getValue().toString()));
            }
        }
    }

    @Generated
    private DataSourcePoolCreator() {
    }
}

