/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.InvalidDataNodesFormatException;

public final class DataNode {
    private static final String DELIMITER = ".";
    private final String dataSourceName;
    private final String tableName;
    private String schemaName;

    public DataNode(String dataNode) {
        boolean isIncludeInstance = DataNode.isActualDataNodesIncludedDataSourceInstance(dataNode);
        if (!isIncludeInstance && !DataNode.isValidDataNode(dataNode, 2)) {
            throw new InvalidDataNodesFormatException(dataNode);
        }
        if (isIncludeInstance && !DataNode.isValidDataNode(dataNode, 3)) {
            throw new InvalidDataNodesFormatException(dataNode);
        }
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNode);
        this.dataSourceName = isIncludeInstance ? (String)segments.get(0) + DELIMITER + (String)segments.get(1) : (String)segments.get(0);
        this.tableName = (String)segments.get(isIncludeInstance ? 2 : 1);
    }

    private static boolean isValidDataNode(String dataNodeStr, Integer tier) {
        return dataNodeStr.contains(DELIMITER) && tier.intValue() == Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)dataNodeStr).size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || this.getClass() != object.getClass()) {
            return false;
        }
        DataNode dataNode = (DataNode)object;
        return Objects.equal((Object)this.dataSourceName.toUpperCase(), (Object)dataNode.dataSourceName.toUpperCase()) && Objects.equal((Object)this.tableName.toUpperCase(), (Object)dataNode.tableName.toUpperCase()) && Objects.equal((Object)(null == this.schemaName ? null : this.schemaName.toUpperCase()), null == dataNode.schemaName ? null : dataNode.schemaName.toUpperCase());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataSourceName.toUpperCase(), this.tableName.toUpperCase(), null == this.schemaName ? null : this.schemaName.toUpperCase()});
    }

    public String format() {
        return this.dataSourceName + DELIMITER + this.tableName;
    }

    public static boolean isActualDataNodesIncludedDataSourceInstance(String actualDataNodes) {
        return DataNode.isValidDataNode(actualDataNodes, 3);
    }

    @Generated
    public DataNode(String dataSourceName, String tableName) {
        this.dataSourceName = dataSourceName;
        this.tableName = tableName;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public String toString() {
        return "DataNode(dataSourceName=" + this.getDataSourceName() + ", tableName=" + this.getTableName() + ", schemaName=" + this.getSchemaName() + ")";
    }
}

