/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.datasource.registry.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.exception.UnsupportedActualDataNodeStructureException;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.SchemaMetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public class SchemaMetaDataUtil {
    public static Collection<SchemaMetaDataLoaderMaterial> getSchemaMetaDataLoaderMaterials(Collection<String> tableNames, GenericSchemaBuilderMaterial material, boolean checkMetaDataEnable) {
        LinkedHashMap<String, Collection<String>> dataSourceTableGroups = new LinkedHashMap<String, Collection<String>>();
        Collection<DatabaseType> notSupportThreeTierStructureStorageTypes = SchemaMetaDataUtil.getNotSupportThreeTierStructureStorageTypes(material.getStorageTypes().values());
        DataNodes dataNodes = new DataNodes(material.getRules());
        for (String each : tableNames) {
            SchemaMetaDataUtil.checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(notSupportThreeTierStructureStorageTypes, dataNodes, each);
            if (checkMetaDataEnable) {
                SchemaMetaDataUtil.addAllActualTableDataNode(material, dataSourceTableGroups, dataNodes, each);
                continue;
            }
            SchemaMetaDataUtil.addOneActualTableDataNode(material, dataSourceTableGroups, dataNodes, each);
        }
        return dataSourceTableGroups.entrySet().stream().map(entry -> new SchemaMetaDataLoaderMaterial((Collection)entry.getValue(), SchemaMetaDataUtil.getDataSource(material, (String)entry.getKey()), material.getStorageTypes().get(entry.getKey()), material.getDefaultSchemaName())).collect(Collectors.toList());
    }

    private static DataSource getDataSource(GenericSchemaBuilderMaterial material, String dataSourceName) {
        return material.getDataSourceMap().get(dataSourceName.contains(".") ? dataSourceName.split("\\.")[0] : dataSourceName);
    }

    private static void checkDataSourceTypeIncludeInstanceAndSetDatabaseTableMap(Collection<DatabaseType> notSupportThreeTierStructureStorageTypes, DataNodes dataNodes, String tableName) {
        for (DataNode dataNode : dataNodes.getDataNodes(tableName)) {
            ShardingSpherePreconditions.checkState((notSupportThreeTierStructureStorageTypes.isEmpty() || !dataNode.getDataSourceName().contains(".") ? 1 : 0) != 0, () -> new UnsupportedActualDataNodeStructureException(dataNode, ((DatabaseType)notSupportThreeTierStructureStorageTypes.iterator().next()).getJdbcUrlPrefixes()));
            if (!dataNode.getDataSourceName().contains(".")) continue;
            String database = dataNode.getDataSourceName().split("\\.")[1];
            GlobalDataSourceRegistry.getInstance().getCachedDatabaseTables().put(dataNode.getTableName(), database);
        }
    }

    private static Collection<DatabaseType> getNotSupportThreeTierStructureStorageTypes(Collection<DatabaseType> storageTypes) {
        LinkedList<DatabaseType> result = new LinkedList<DatabaseType>();
        for (DatabaseType each : storageTypes) {
            if ("MySQL".equals(each.getType())) continue;
            result.add(each);
        }
        return result;
    }

    private static void addOneActualTableDataNode(GenericSchemaBuilderMaterial material, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Optional<DataNode> dataNode = dataNodes.getDataNodes(table).stream().filter(each -> SchemaMetaDataUtil.isSameDataSourceNameSchemaName(material, each)).findFirst();
        String dataSourceName = dataNode.map(DataNode::getDataSourceName).orElseGet(() -> material.getDataSourceMap().keySet().iterator().next());
        String tableName = dataNode.map(DataNode::getTableName).orElse(table);
        SchemaMetaDataUtil.addDataSourceTableGroups(dataSourceName, tableName, dataSourceTableGroups);
    }

    private static boolean isSameDataSourceNameSchemaName(GenericSchemaBuilderMaterial material, DataNode dataNode) {
        String dataSourceName;
        String string = dataSourceName = dataNode.getDataSourceName().contains(".") ? dataNode.getDataSourceName().split("\\.")[0] : dataNode.getDataSourceName();
        if (!material.getDataSourceMap().containsKey(dataSourceName)) {
            return false;
        }
        return null == dataNode.getSchemaName() || dataNode.getSchemaName().equalsIgnoreCase(material.getDefaultSchemaName());
    }

    private static void addAllActualTableDataNode(GenericSchemaBuilderMaterial material, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Collection<DataNode> tableDataNodes = dataNodes.getDataNodes(table);
        if (tableDataNodes.isEmpty()) {
            SchemaMetaDataUtil.addDataSourceTableGroups(material.getDataSourceMap().keySet().iterator().next(), table, dataSourceTableGroups);
        } else {
            tableDataNodes.forEach(each -> SchemaMetaDataUtil.addDataSourceTableGroups(each.getDataSourceName(), each.getTableName(), dataSourceTableGroups));
        }
    }

    private static void addDataSourceTableGroups(String dataSourceName, String tableName, Map<String, Collection<String>> dataSourceTableGroups) {
        Collection tables = dataSourceTableGroups.getOrDefault(dataSourceName, new LinkedList());
        tables.add(tableName);
        dataSourceTableGroups.putIfAbsent(dataSourceName, tables);
    }

    @Generated
    private SchemaMetaDataUtil() {
    }
}

