/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.spi.DataTypeLoaderFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.spi.DialectSchemaMetaDataLoader;

public final class SQLServerSchemaMetaDataLoader
implements DialectSchemaMetaDataLoader {
    private static final String TABLE_META_DATA_SQL_NO_ORDER = "SELECT obj.name AS TABLE_NAME, col.name AS COLUMN_NAME, t.name AS DATA_TYPE, col.collation_name AS COLLATION_NAME, col.column_id, is_identity AS IS_IDENTITY, %s (SELECT TOP 1 ind.is_primary_key FROM sys.index_columns ic LEFT JOIN sys.indexes ind ON ic.object_id = ind.object_id AND ic.index_id = ind.index_id AND ind.name LIKE 'PK_%%' WHERE ic.object_id = obj.object_id AND ic.column_id = col.column_id) AS IS_PRIMARY_KEY FROM sys.objects obj INNER JOIN sys.columns col ON obj.object_id = col.object_id LEFT JOIN sys.types t ON t.user_type_id = col.user_type_id";
    private static final String ORDER_BY_COLUMN_ID = " ORDER BY col.column_id";
    private static final String TABLE_META_DATA_SQL = "SELECT obj.name AS TABLE_NAME, col.name AS COLUMN_NAME, t.name AS DATA_TYPE, col.collation_name AS COLLATION_NAME, col.column_id, is_identity AS IS_IDENTITY, %s (SELECT TOP 1 ind.is_primary_key FROM sys.index_columns ic LEFT JOIN sys.indexes ind ON ic.object_id = ind.object_id AND ic.index_id = ind.index_id AND ind.name LIKE 'PK_%%' WHERE ic.object_id = obj.object_id AND ic.column_id = col.column_id) AS IS_PRIMARY_KEY FROM sys.objects obj INNER JOIN sys.columns col ON obj.object_id = col.object_id LEFT JOIN sys.types t ON t.user_type_id = col.user_type_id ORDER BY col.column_id";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT obj.name AS TABLE_NAME, col.name AS COLUMN_NAME, t.name AS DATA_TYPE, col.collation_name AS COLLATION_NAME, col.column_id, is_identity AS IS_IDENTITY, %s (SELECT TOP 1 ind.is_primary_key FROM sys.index_columns ic LEFT JOIN sys.indexes ind ON ic.object_id = ind.object_id AND ic.index_id = ind.index_id AND ind.name LIKE 'PK_%%' WHERE ic.object_id = obj.object_id AND ic.column_id = col.column_id) AS IS_PRIMARY_KEY FROM sys.objects obj INNER JOIN sys.columns col ON obj.object_id = col.object_id LEFT JOIN sys.types t ON t.user_type_id = col.user_type_id WHERE obj.name IN (%s) ORDER BY col.column_id";
    private static final String INDEX_META_DATA_SQL = "SELECT a.name AS INDEX_NAME, c.name AS TABLE_NAME FROM sys.indexes a JOIN sys.objects c ON a.object_id = c.object_id WHERE a.index_id NOT IN (0, 255) AND c.name IN (%s)";
    private static final int HIDDEN_COLUMN_START_MAJOR_VERSION = 15;

    @Override
    public Collection<SchemaMetaData> load(DataSource dataSource, Collection<String> tables, String defaultSchemaName) throws SQLException {
        LinkedList<TableMetaData> tableMetaDataList = new LinkedList<TableMetaData>();
        Map<String, Collection<ColumnMetaData>> columnMetaDataMap = this.loadColumnMetaDataMap(dataSource, tables);
        if (!columnMetaDataMap.isEmpty()) {
            Map<String, Collection<IndexMetaData>> indexMetaDataMap = this.loadIndexMetaData(dataSource, columnMetaDataMap.keySet());
            for (Map.Entry<String, Collection<ColumnMetaData>> entry : columnMetaDataMap.entrySet()) {
                Collection indexMetaDataList = indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList());
                tableMetaDataList.add(new TableMetaData(entry.getKey(), entry.getValue(), indexMetaDataList, Collections.emptyList()));
            }
        }
        return Collections.singletonList(new SchemaMetaData(defaultSchemaName, tableMetaDataList));
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables, connection.getMetaData()));){
            Map<String, Integer> dataTypes = DataTypeLoaderFactory.getInstance(DatabaseTypeFactory.getInstance("SQLServer")).load(connection.getMetaData());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, resultSet, connection.getMetaData());
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, ResultSet resultSet, DatabaseMetaData databaseMetaData) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = resultSet.getString("DATA_TYPE");
        String collationName = resultSet.getString("COLLATION_NAME");
        boolean primaryKey = "1".equals(resultSet.getString("IS_PRIMARY_KEY"));
        boolean generated = "1".equals(resultSet.getString("IS_IDENTITY"));
        boolean caseSensitive = null != collationName && collationName.indexOf("_CS") > 0;
        boolean isVisible = !this.versionContainsHiddenColumn(databaseMetaData) || !"1".equals(resultSet.getString("IS_HIDDEN"));
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), primaryKey, generated, caseSensitive, isVisible, false);
    }

    private String getTableMetaDataSQL(Collection<String> tables, DatabaseMetaData databaseMetaData) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(24);
        if (this.versionContainsHiddenColumn(databaseMetaData)) {
            stringBuilder.append("is_hidden AS IS_HIDDEN,");
        }
        String isHidden = stringBuilder.toString();
        return tables.isEmpty() ? String.format(TABLE_META_DATA_SQL, isHidden) : String.format(TABLE_META_DATA_SQL_IN_TABLES, isHidden, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private boolean versionContainsHiddenColumn(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 15;
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                String tableName = resultSet.getString("TABLE_NAME");
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new LinkedList());
                }
                ((Collection)result.get(tableName)).add(new IndexMetaData(indexName));
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    public String getType() {
        return "SQLServer";
    }
}

