/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.dialect;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.adapter.MetaDataLoaderConnectionAdapter;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.spi.DataTypeLoaderFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.spi.DialectSchemaMetaDataLoader;

public final class OracleSchemaMetaDataLoader
implements DialectSchemaMetaDataLoader {
    private static final String TABLE_META_DATA_SQL_NO_ORDER = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_ID, HIDDEN_COLUMN %s FROM ALL_TAB_COLS WHERE OWNER = ?";
    private static final String ORDER_BY_COLUMN_ID = " ORDER BY COLUMN_ID";
    private static final String TABLE_META_DATA_SQL = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_ID, HIDDEN_COLUMN %s FROM ALL_TAB_COLS WHERE OWNER = ? ORDER BY COLUMN_ID";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_ID, HIDDEN_COLUMN %s FROM ALL_TAB_COLS WHERE OWNER = ? AND TABLE_NAME IN (%s) ORDER BY COLUMN_ID";
    private static final String INDEX_META_DATA_SQL = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, INDEX_NAME FROM ALL_INDEXES WHERE OWNER = ? AND TABLE_NAME IN (%s)";
    private static final String PRIMARY_KEY_META_DATA_SQL = "SELECT A.OWNER AS TABLE_SCHEMA, A.TABLE_NAME AS TABLE_NAME, B.COLUMN_NAME AS COLUMN_NAME FROM ALL_CONSTRAINTS A INNER JOIN ALL_CONS_COLUMNS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME WHERE CONSTRAINT_TYPE = 'P' AND A.OWNER = ?";
    private static final String PRIMARY_KEY_META_DATA_SQL_IN_TABLES = "SELECT A.OWNER AS TABLE_SCHEMA, A.TABLE_NAME AS TABLE_NAME, B.COLUMN_NAME AS COLUMN_NAME FROM ALL_CONSTRAINTS A INNER JOIN ALL_CONS_COLUMNS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME WHERE CONSTRAINT_TYPE = 'P' AND A.OWNER = ? AND A.TABLE_NAME IN (%s)";
    private static final int COLLATION_START_MAJOR_VERSION = 12;
    private static final int COLLATION_START_MINOR_VERSION = 2;
    private static final int IDENTITY_COLUMN_START_MINOR_VERSION = 1;
    private static final int MAX_EXPRESSION_SIZE = 1000;

    @Override
    public Collection<SchemaMetaData> load(DataSource dataSource, Collection<String> tables, String defaultSchemaName) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> columnMetaDataMap = new HashMap<String, Collection<ColumnMetaData>>(tables.size(), 1.0f);
        HashMap<String, Collection<IndexMetaData>> indexMetaDataMap = new HashMap<String, Collection<IndexMetaData>>(tables.size(), 1.0f);
        try (MetaDataLoaderConnectionAdapter connection = new MetaDataLoaderConnectionAdapter(DatabaseTypeFactory.getInstance("Oracle"), dataSource.getConnection());){
            for (List list : Lists.partition(new ArrayList<String>(tables), (int)1000)) {
                columnMetaDataMap.putAll(this.loadColumnMetaDataMap(connection, list));
                indexMetaDataMap.putAll(this.loadIndexMetaData(connection, list));
            }
        }
        LinkedList<TableMetaData> tableMetaDataList = new LinkedList<TableMetaData>();
        for (Map.Entry entry : columnMetaDataMap.entrySet()) {
            tableMetaDataList.add(new TableMetaData((String)entry.getKey(), (Collection)entry.getValue(), indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList()), Collections.emptyList()));
        }
        return Collections.singletonList(new SchemaMetaData(defaultSchemaName, tableMetaDataList));
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(Connection connection, Collection<String> tables) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>(tables.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables, connection.getMetaData()));){
            Map<String, Integer> dataTypes = DataTypeLoaderFactory.getInstance(DatabaseTypeFactory.getInstance("Oracle")).load(connection.getMetaData());
            Map<String, Collection<String>> tablePrimaryKeys = this.loadTablePrimaryKeys(connection, tables);
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, resultSet, tablePrimaryKeys.getOrDefault(tableName, Collections.emptyList()), connection.getMetaData());
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, ResultSet resultSet, Collection<String> primaryKeys, DatabaseMetaData databaseMetaData) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = this.getOriginalDataType(resultSet.getString("DATA_TYPE"));
        boolean primaryKey = primaryKeys.contains(columnName);
        boolean generated = this.versionContainsIdentityColumn(databaseMetaData) && "YES".equals(resultSet.getString("IDENTITY_COLUMN"));
        boolean caseSensitive = this.versionContainsCollation(databaseMetaData) && resultSet.getString("COLLATION").endsWith("_CS");
        boolean isVisible = "NO".equals(resultSet.getString("HIDDEN_COLUMN"));
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), primaryKey, generated, caseSensitive, isVisible, false);
    }

    private String getOriginalDataType(String dataType) {
        int index = dataType.indexOf("(");
        if (index > 0) {
            return dataType.substring(0, index);
        }
        return dataType;
    }

    private String getTableMetaDataSQL(Collection<String> tables, DatabaseMetaData databaseMetaData) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(28);
        if (this.versionContainsIdentityColumn(databaseMetaData)) {
            stringBuilder.append(", IDENTITY_COLUMN");
        }
        if (this.versionContainsCollation(databaseMetaData)) {
            stringBuilder.append(", COLLATION");
        }
        String collation = stringBuilder.toString();
        return tables.isEmpty() ? String.format(TABLE_META_DATA_SQL, collation) : String.format(TABLE_META_DATA_SQL_IN_TABLES, collation, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private boolean versionContainsCollation(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 12 && databaseMetaData.getDatabaseMinorVersion() >= 2;
    }

    private boolean versionContainsIdentityColumn(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 12 && databaseMetaData.getDatabaseMinorVersion() >= 1;
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(Connection connection, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>(tableNames.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));){
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String indexName = resultSet.getString("INDEX_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(new IndexMetaData(indexName));
                }
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<String>> loadTablePrimaryKeys(Connection connection, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getPrimaryKeyMetaDataSQL(tableNames));){
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    result.computeIfAbsent(tableName, k -> new LinkedList()).add(columnName);
                }
            }
        }
        return result;
    }

    private String getPrimaryKeyMetaDataSQL(Collection<String> tables) {
        return tables.isEmpty() ? PRIMARY_KEY_META_DATA_SQL : String.format(PRIMARY_KEY_META_DATA_SQL_IN_TABLES, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    public String getType() {
        return "Oracle";
    }
}

