/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;

public final class InstanceContext {
    private final ComputeNodeInstance instance;
    private final WorkerIdGenerator workerIdGenerator;
    private final ModeConfiguration modeConfiguration;
    private final LockContext lockContext;
    private final EventBusContext eventBusContext;
    private final Collection<ComputeNodeInstance> allClusterInstances = new LinkedList<ComputeNodeInstance>();

    public void updateInstanceStatus(String instanceId, String status) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.switchState(status);
        }
        this.updateRelatedComputeNodeInstancesStatus(instanceId, status);
    }

    private void updateRelatedComputeNodeInstancesStatus(String instanceId, String status) {
        for (ComputeNodeInstance each : this.allClusterInstances) {
            if (!each.getMetaData().getId().equals(instanceId)) continue;
            each.switchState(status);
        }
    }

    public void updateWorkerId(String instanceId, Integer workerId) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.setWorkerId(workerId);
        }
        this.allClusterInstances.stream().filter(each -> each.getMetaData().getId().equals(instanceId)).forEach(each -> each.setWorkerId(workerId));
    }

    public void updateLabel(String instanceId, Collection<String> labels) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.setLabels(labels);
        }
        this.allClusterInstances.stream().filter(each -> each.getMetaData().getId().equals(instanceId)).forEach(each -> each.setLabels(labels));
    }

    public int getWorkerId() {
        return this.instance.getWorkerId();
    }

    public int generateWorkerId(Properties props) {
        int result = this.workerIdGenerator.generate(props);
        this.instance.setWorkerId(result);
        return result;
    }

    public void addComputeNodeInstance(ComputeNodeInstance instance) {
        this.allClusterInstances.removeIf(each -> each.getMetaData().getId().equalsIgnoreCase(instance.getMetaData().getId()));
        this.allClusterInstances.add(instance);
    }

    public void deleteComputeNodeInstance(ComputeNodeInstance instance) {
        this.allClusterInstances.removeIf(each -> each.getMetaData().getId().equalsIgnoreCase(instance.getMetaData().getId()));
    }

    public List<InstanceMetaData> getAllClusterInstances(InstanceType instanceType, Collection<String> labels) {
        ArrayList<InstanceMetaData> result = new ArrayList<InstanceMetaData>(this.allClusterInstances.size());
        for (ComputeNodeInstance each : this.allClusterInstances) {
            if (each.getMetaData().getType() != instanceType) continue;
            if (!labels.stream().anyMatch(each.getLabels()::contains)) continue;
            result.add(each.getMetaData());
        }
        return result;
    }

    public Optional<ComputeNodeInstance> getComputeNodeInstanceById(String instanceId) {
        return this.allClusterInstances.stream().filter(each -> instanceId.equals(each.getCurrentInstanceId())).findFirst();
    }

    public boolean isCluster() {
        return "Cluster".equals(this.modeConfiguration.getType());
    }

    @Generated
    public InstanceContext(ComputeNodeInstance instance, WorkerIdGenerator workerIdGenerator, ModeConfiguration modeConfiguration, LockContext lockContext, EventBusContext eventBusContext) {
        this.instance = instance;
        this.workerIdGenerator = workerIdGenerator;
        this.modeConfiguration = modeConfiguration;
        this.lockContext = lockContext;
        this.eventBusContext = eventBusContext;
    }

    @Generated
    public ComputeNodeInstance getInstance() {
        return this.instance;
    }

    @Generated
    public ModeConfiguration getModeConfiguration() {
        return this.modeConfiguration;
    }

    @Generated
    public LockContext getLockContext() {
        return this.lockContext;
    }

    @Generated
    public EventBusContext getEventBusContext() {
        return this.eventBusContext;
    }

    @Generated
    public Collection<ComputeNodeInstance> getAllClusterInstances() {
        return this.allClusterInstances;
    }
}

