/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLHintExtractor {
    private final HintValueContext hintValueContext;

    public SQLHintExtractor(String sqlComment) {
        this.hintValueContext = Strings.isNullOrEmpty((String)sqlComment) ? new HintValueContext() : SQLHintUtils.extractHint(sqlComment);
    }

    public SQLHintExtractor(SQLStatement sqlStatement) {
        this(sqlStatement, new HintValueContext());
    }

    public SQLHintExtractor(SQLStatement sqlStatement, HintValueContext hintValueContext) {
        this.hintValueContext = sqlStatement instanceof AbstractSQLStatement && !((AbstractSQLStatement)sqlStatement).getCommentSegments().isEmpty() ? SQLHintUtils.extractHint(((CommentSegment)((AbstractSQLStatement)sqlStatement).getCommentSegments().iterator().next()).getText()) : hintValueContext;
    }

    public boolean isHintWriteRouteOnly() {
        return this.hintValueContext.isWriteRouteOnly();
    }

    public boolean isHintSkipEncryptRewrite() {
        return this.hintValueContext.isSkipEncryptRewrite();
    }

    public boolean isShadow() {
        return this.hintValueContext.isShadow();
    }

    public Collection<String> findDisableAuditNames() {
        return SQLHintUtils.getSplitterSQLHintValue(this.hintValueContext.getDisableAuditNames());
    }

    public Collection<Comparable<?>> getHintShardingDatabaseValue(String tableName) {
        String key = String.join((CharSequence)".", tableName.toUpperCase(), SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
        return this.hintValueContext.getShardingDatabaseValues().containsKey((Object)key) ? this.hintValueContext.getShardingDatabaseValues().get((Object)key) : this.hintValueContext.getShardingDatabaseValues().get((Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
    }

    public boolean containsHintShardingDatabaseValue(String tableName) {
        String key = Joiner.on((String)".").join((Object)tableName.toUpperCase(), (Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey(), new Object[0]);
        return this.hintValueContext.getShardingDatabaseValues().containsKey((Object)key) || this.hintValueContext.getShardingDatabaseValues().containsKey((Object)SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY.getKey());
    }

    public Collection<Comparable<?>> getHintShardingTableValue(String tableName) {
        String key = String.join((CharSequence)".", tableName.toUpperCase(), SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
        return this.hintValueContext.getShardingTableValues().containsKey((Object)key) ? this.hintValueContext.getShardingTableValues().get((Object)key) : this.hintValueContext.getShardingTableValues().get((Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
    }

    public boolean containsHintShardingTableValue(String tableName) {
        String key = Joiner.on((String)".").join((Object)tableName.toUpperCase(), (Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey(), new Object[0]);
        return this.hintValueContext.getShardingTableValues().containsKey((Object)key) || this.hintValueContext.getShardingTableValues().containsKey((Object)SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY.getKey());
    }

    public boolean containsHintShardingValue(String tableName) {
        return this.containsHintShardingDatabaseValue(tableName) || this.containsHintShardingTableValue(tableName);
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }
}

