/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.distsql.exception.rule;

import java.util.Collection;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.XOpenSQLState;

public final class InvalidAlgorithmConfigurationException
extends RuleDefinitionViolationException {
    private static final long serialVersionUID = 9076740384552385180L;

    public InvalidAlgorithmConfigurationException(String algorithmType, Collection<String> algorithms) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 150, String.format("Invalid %s algorithms `%s`.", algorithmType, algorithms), new Object[0]);
    }

    public InvalidAlgorithmConfigurationException(String algorithmType, String algorithm) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 150, String.format("Invalid %s algorithm `%s`.", algorithmType, algorithm), new Object[0]);
    }

    public InvalidAlgorithmConfigurationException(String algorithmType) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 150, String.format("Invalid %s algorithm.", algorithmType), new Object[0]);
    }
}

