/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.cursor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.context.cursor.CursorDefinition;
import org.apache.shardingsphere.infra.context.cursor.FetchGroup;

public final class CursorConnectionContext
implements AutoCloseable {
    private final Map<String, List<FetchGroup>> orderByValueGroups = new ConcurrentHashMap<String, List<FetchGroup>>();
    private final Map<String, Long> minGroupRowCounts = new ConcurrentHashMap<String, Long>();
    private final Map<String, CursorDefinition> cursorDefinitions = new ConcurrentHashMap<String, CursorDefinition>();

    @Override
    public void close() {
        this.orderByValueGroups.clear();
        this.minGroupRowCounts.clear();
        this.cursorDefinitions.clear();
    }

    public void removeCursorName(String name) {
        this.orderByValueGroups.remove(name);
        this.minGroupRowCounts.remove(name);
        this.cursorDefinitions.remove(name);
    }

    @Generated
    public Map<String, List<FetchGroup>> getOrderByValueGroups() {
        return this.orderByValueGroups;
    }

    @Generated
    public Map<String, Long> getMinGroupRowCounts() {
        return this.minGroupRowCounts;
    }

    @Generated
    public Map<String, CursorDefinition> getCursorDefinitions() {
        return this.cursorDefinitions;
    }
}

