/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource.creator.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.creator.impl.AbstractDataSourceCreator;

public final class HikariDataSourceCreator
extends AbstractDataSourceCreator {
    private final Map<String, Object> skippedProperties = new HashMap<String, Object>(2, 1.0f);

    public HikariDataSourceCreator() {
        this.skippedProperties.put("minimumIdle", -1);
        this.skippedProperties.put("maximumPoolSize", -1);
    }

    @Override
    public DataSource createDataSource(DataSourceConfiguration dataSourceConfig) {
        this.addPropertySynonyms(dataSourceConfig);
        DataSource result = this.buildDataSource(dataSourceConfig.getDataSourceClassName());
        Method[] methods = result.getClass().getMethods();
        for (Map.Entry<String, Object> entry : dataSourceConfig.getAllProps().entrySet()) {
            if (this.isInvalidProperty(entry.getKey(), entry.getValue())) continue;
            this.setField(result, methods, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private void addPropertySynonyms(DataSourceConfiguration dataSourceConfig) {
        dataSourceConfig.addPropertySynonym("maxPoolSize", "maximumPoolSize");
        dataSourceConfig.addPropertySynonym("minPoolSize", "minimumIdle");
    }

    private boolean isInvalidProperty(String property, Object value) {
        return this.skippedProperties.containsKey(property) && null != value && value.equals(this.skippedProperties.get(property));
    }

    @Override
    public DataSourceConfiguration createDataSourceConfiguration(DataSource dataSource) {
        return this.buildDataSourceConfig(dataSource);
    }

    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }
}

