/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.pagination.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.LimitPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.RowNumberPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.TopPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.OracleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.SQLServerStatement;

public final class PaginationContextEngine {
    public PaginationContext createPaginationContext(SelectStatement selectStatement, ProjectionsContext projectionsContext, List<Object> params, Collection<WhereSegment> whereSegments) {
        Optional limitSegment = SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement);
        if (limitSegment.isPresent()) {
            return new LimitPaginationContextEngine().createPaginationContext((LimitSegment)limitSegment.get(), params);
        }
        Optional<TopProjectionSegment> topProjectionSegment = this.findTopProjection(selectStatement);
        LinkedList<ExpressionSegment> expressions = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : whereSegments) {
            expressions.add(each.getExpr());
        }
        if (topProjectionSegment.isPresent()) {
            return new TopPaginationContextEngine().createPaginationContext(topProjectionSegment.get(), expressions, params);
        }
        if (!expressions.isEmpty() && this.containsRowNumberPagination(selectStatement)) {
            return new RowNumberPaginationContextEngine().createPaginationContext(expressions, projectionsContext, params);
        }
        return new PaginationContext(null, null, params);
    }

    private boolean containsRowNumberPagination(SelectStatement selectStatement) {
        return selectStatement instanceof OracleStatement || selectStatement instanceof SQLServerStatement;
    }

    private Optional<TopProjectionSegment> findTopProjection(SelectStatement selectStatement) {
        List subqueryTableSegments = SQLUtil.getSubqueryTableSegmentFromTableSegment((TableSegment)selectStatement.getFrom());
        for (SubqueryTableSegment subquery : subqueryTableSegments) {
            SelectStatement subquerySelect = subquery.getSubquery().getSelect();
            for (ProjectionSegment each : subquerySelect.getProjections().getProjections()) {
                if (!(each instanceof TopProjectionSegment)) continue;
                return Optional.of((TopProjectionSegment)each);
            }
        }
        return Optional.empty();
    }
}

