/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.hint.HintValueContext;

public final class QueryContext {
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private HintValueContext hintValueContext;
    private String sqlStatementDatabaseName;

    public QueryContext(SQLStatementContext<?> sqlStatementContext, String sql, List<Object> params) {
        this(sqlStatementContext, sql, params, new HintValueContext());
    }

    public QueryContext(SQLStatementContext<?> sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = params;
        this.hintValueContext = hintValueContext;
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)((Object)sqlStatementContext)).getTablesContext().getDatabaseName().ifPresent(optional -> {
                this.sqlStatementDatabaseName = optional;
            });
        }
    }

    public Optional<String> findSqlStatementDatabaseName() {
        return Optional.ofNullable(this.sqlStatementDatabaseName);
    }

    @Generated
    public SQLStatementContext<?> getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }

    @Generated
    public String getSqlStatementDatabaseName() {
        return this.sqlStatementDatabaseName;
    }
}

