/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.binder.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.engine.GeneratedKeyContextEngine;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertSelectContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class InsertStatementContext
extends CommonSQLStatementContext<InsertStatement>
implements TableAvailable,
ParameterAware {
    private final TablesContext tablesContext;
    private final List<String> columnNames;
    private final Map<String, ShardingSphereDatabase> databases;
    private final String defaultDatabaseName;
    private final List<String> insertColumnNames;
    private final List<List<ExpressionSegment>> valueExpressions;
    private List<InsertValueContext> insertValueContexts;
    private InsertSelectContext insertSelectContext;
    private OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext;
    private GeneratedKeyContext generatedKeyContext;

    public InsertStatementContext(Map<String, ShardingSphereDatabase> databases, List<Object> parameters, InsertStatement sqlStatement, String defaultDatabaseName) {
        super(sqlStatement);
        this.databases = databases;
        this.defaultDatabaseName = defaultDatabaseName;
        this.insertColumnNames = this.getInsertColumnNames();
        this.valueExpressions = this.getAllValueExpressions(sqlStatement);
        AtomicInteger parametersOffset = new AtomicInteger(0);
        this.insertValueContexts = this.getInsertValueContexts(parameters, parametersOffset, this.valueExpressions);
        this.insertSelectContext = this.getInsertSelectContext(databases, parameters, parametersOffset, defaultDatabaseName).orElse(null);
        this.onDuplicateKeyUpdateValueContext = this.getOnDuplicateKeyUpdateValueContext(parameters, parametersOffset).orElse(null);
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments(), this.getDatabaseType());
        ShardingSphereSchema schema = this.getSchema(databases, defaultDatabaseName);
        this.columnNames = this.containsInsertColumns() ? this.insertColumnNames : schema.getVisibleColumnNames(sqlStatement.getTable().getTableName().getIdentifier().getValue());
        this.generatedKeyContext = new GeneratedKeyContextEngine(sqlStatement, schema).createGenerateKeyContext(this.insertColumnNames, this.getAllValueExpressions(sqlStatement), parameters).orElse(null);
    }

    private ShardingSphereSchema getSchema(Map<String, ShardingSphereDatabase> databases, String defaultDatabaseName) {
        String databaseName = this.tablesContext.getDatabaseName().orElse(defaultDatabaseName);
        if (null == databaseName) {
            throw new NoDatabaseSelectedException();
        }
        ShardingSphereDatabase database = databases.get(databaseName.toLowerCase());
        if (null == database) {
            throw new UnknownDatabaseException(databaseName);
        }
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.getDatabaseType(), (String)databaseName);
        return this.tablesContext.getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchema));
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromInsert((InsertStatement)this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    private List<InsertValueContext> getInsertValueContexts(List<Object> parameters, AtomicInteger parametersOffset, List<List<ExpressionSegment>> valueExpressions) {
        LinkedList<InsertValueContext> result = new LinkedList<InsertValueContext>();
        for (Collection collection : valueExpressions) {
            InsertValueContext insertValueContext = new InsertValueContext(collection, parameters, parametersOffset.get());
            result.add(insertValueContext);
            parametersOffset.addAndGet(insertValueContext.getParameterCount());
        }
        return result;
    }

    private Optional<InsertSelectContext> getInsertSelectContext(Map<String, ShardingSphereDatabase> databases, List<Object> parameters, AtomicInteger parametersOffset, String defaultDatabaseName) {
        if (!((InsertStatement)this.getSqlStatement()).getInsertSelect().isPresent()) {
            return Optional.empty();
        }
        SubquerySegment insertSelectSegment = (SubquerySegment)((InsertStatement)this.getSqlStatement()).getInsertSelect().get();
        SelectStatementContext selectStatementContext = new SelectStatementContext(databases, parameters, insertSelectSegment.getSelect(), defaultDatabaseName);
        InsertSelectContext insertSelectContext = new InsertSelectContext(selectStatementContext, parameters, parametersOffset.get());
        parametersOffset.addAndGet(insertSelectContext.getParameterCount());
        return Optional.of(insertSelectContext);
    }

    private Optional<OnDuplicateUpdateContext> getOnDuplicateKeyUpdateValueContext(List<Object> parameters, AtomicInteger parametersOffset) {
        Optional onDuplicateKeyColumnsSegment = InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatement)this.getSqlStatement()));
        if (!onDuplicateKeyColumnsSegment.isPresent()) {
            return Optional.empty();
        }
        Collection onDuplicateKeyColumns = ((OnDuplicateKeyColumnsSegment)onDuplicateKeyColumnsSegment.get()).getColumns();
        OnDuplicateUpdateContext onDuplicateUpdateContext = new OnDuplicateUpdateContext(onDuplicateKeyColumns, parameters, parametersOffset.get());
        parametersOffset.addAndGet(onDuplicateUpdateContext.getParameterCount());
        return Optional.of(onDuplicateUpdateContext);
    }

    public Iterator<String> getDescendingColumnNames() {
        return new LinkedList<String>(this.columnNames).descendingIterator();
    }

    public List<List<Object>> getGroupedParameters() {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (InsertValueContext each : this.insertValueContexts) {
            result.add(each.getParameters());
        }
        if (null != this.insertSelectContext) {
            result.add(this.insertSelectContext.getParameters());
        }
        return result;
    }

    public List<Object> getOnDuplicateKeyUpdateParameters() {
        return null == this.onDuplicateKeyUpdateValueContext ? new ArrayList() : this.onDuplicateKeyUpdateValueContext.getParameters();
    }

    public Optional<GeneratedKeyContext> getGeneratedKeyContext() {
        return Optional.ofNullable(this.generatedKeyContext);
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getTables();
    }

    public boolean containsInsertColumns() {
        InsertStatement insertStatement = (InsertStatement)this.getSqlStatement();
        return !insertStatement.getColumns().isEmpty() || InsertStatementHandler.getSetAssignmentSegment((InsertStatement)insertStatement).isPresent();
    }

    public int getValueListCount() {
        InsertStatement insertStatement = (InsertStatement)this.getSqlStatement();
        return InsertStatementHandler.getSetAssignmentSegment((InsertStatement)insertStatement).isPresent() ? 1 : insertStatement.getValues().size();
    }

    public List<String> getInsertColumnNames() {
        InsertStatement insertStatement = (InsertStatement)this.getSqlStatement();
        return InsertStatementHandler.getSetAssignmentSegment((InsertStatement)insertStatement).map(this::getColumnNamesForSetAssignment).orElseGet(() -> this.getColumnNamesForInsertColumns(insertStatement.getColumns()));
    }

    private List<String> getColumnNamesForSetAssignment(SetAssignmentSegment setAssignment) {
        LinkedList<String> result = new LinkedList<String>();
        for (AssignmentSegment each : setAssignment.getAssignments()) {
            result.add(((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<String> getColumnNamesForInsertColumns(Collection<ColumnSegment> columns) {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnSegment each : columns) {
            result.add(each.getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<List<ExpressionSegment>> getAllValueExpressions(InsertStatement insertStatement) {
        Optional setAssignment = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)insertStatement);
        return setAssignment.map(optional -> Collections.singletonList(this.getAllValueExpressionsFromSetAssignment((SetAssignmentSegment)optional))).orElseGet(() -> this.getAllValueExpressionsFromValues(insertStatement.getValues()));
    }

    private List<ExpressionSegment> getAllValueExpressionsFromSetAssignment(SetAssignmentSegment setAssignment) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(setAssignment.getAssignments().size());
        for (AssignmentSegment each : setAssignment.getAssignments()) {
            result.add(each.getValue());
        }
        return result;
    }

    private List<List<ExpressionSegment>> getAllValueExpressionsFromValues(Collection<InsertValuesSegment> values) {
        ArrayList<List<ExpressionSegment>> result = new ArrayList<List<ExpressionSegment>>(values.size());
        for (InsertValuesSegment each : values) {
            result.add(each.getValues());
        }
        return result;
    }

    @Override
    public void setUpParameters(List<Object> parameters) {
        AtomicInteger parametersOffset = new AtomicInteger(0);
        this.insertValueContexts = this.getInsertValueContexts(parameters, parametersOffset, this.valueExpressions);
        this.insertSelectContext = this.getInsertSelectContext(this.databases, parameters, parametersOffset, this.defaultDatabaseName).orElse(null);
        this.onDuplicateKeyUpdateValueContext = this.getOnDuplicateKeyUpdateValueContext(parameters, parametersOffset).orElse(null);
        ShardingSphereSchema schema = this.getSchema(this.databases, this.defaultDatabaseName);
        this.generatedKeyContext = new GeneratedKeyContextEngine((InsertStatement)this.getSqlStatement(), schema).createGenerateKeyContext(this.insertColumnNames, this.valueExpressions, parameters).orElse(null);
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public Map<String, ShardingSphereDatabase> getDatabases() {
        return this.databases;
    }

    @Generated
    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    @Generated
    public List<List<ExpressionSegment>> getValueExpressions() {
        return this.valueExpressions;
    }

    @Generated
    public List<InsertValueContext> getInsertValueContexts() {
        return this.insertValueContexts;
    }

    @Generated
    public InsertSelectContext getInsertSelectContext() {
        return this.insertSelectContext;
    }

    @Generated
    public OnDuplicateUpdateContext getOnDuplicateKeyUpdateValueContext() {
        return this.onDuplicateKeyUpdateValueContext;
    }
}

