/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.kernel;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.KernelDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.KernelDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.InventoryIncrementalRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.ReadOrWriteSegment;
import org.apache.shardingsphere.distsql.parser.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.hint.ClearHintStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ConvertYamlConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowComputeNodeInfoStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowComputeNodeModeStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowComputeNodesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowDistVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowDistVariablesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowMigrationRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.AlterComputeNodeStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.AlterInventoryIncrementalRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.ApplyDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.DiscardDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.LabelComputeNodeStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.PrepareDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.RefreshDatabaseMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.RefreshTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.SetDistVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.SetInstanceStatusStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.UnlabelComputeNodeStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterStorageUnitStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.RegisterStorageUnitStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.SetDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.UnregisterStorageUnitStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.CountSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowRulesUsedStorageUnitStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowStorageUnitsStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class KernelDistSQLStatementVisitor
extends KernelDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitRegisterStorageUnit(KernelDistSQLStatementParser.RegisterStorageUnitContext ctx) {
        return new RegisterStorageUnitStatement((Collection)ctx.storageUnitDefinition().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterStorageUnit(KernelDistSQLStatementParser.AlterStorageUnitContext ctx) {
        return new AlterStorageUnitStatement((Collection)ctx.storageUnitDefinition().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowTableMetadata(KernelDistSQLStatementParser.ShowTableMetadataContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
        return new ShowTableMetadataStatement(tableNames, null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitStorageUnitDefinition(KernelDistSQLStatementParser.StorageUnitDefinitionContext ctx) {
        String user = this.getIdentifierValue((ParseTree)ctx.user());
        String password = null == ctx.password() ? "" : this.getPassword(ctx.password());
        Properties props = this.getProperties(ctx.propertiesDefinition());
        URLBasedDataSourceSegment result = null;
        if (null != ctx.urlSource()) {
            result = new URLBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.urlSource().url()), user, password, props);
        }
        if (null != ctx.simpleSource()) {
            result = new HostnameAndPortBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.simpleSource().hostname()), ctx.simpleSource().port().getText(), this.getIdentifierValue((ParseTree)ctx.simpleSource().dbName()), user, password, props);
        }
        return result;
    }

    private String getPassword(KernelDistSQLStatementParser.PasswordContext ctx) {
        return this.getIdentifierValue((ParseTree)ctx);
    }

    @Override
    public ASTNode visitShowComputeNodes(KernelDistSQLStatementParser.ShowComputeNodesContext ctx) {
        return new ShowComputeNodesStatement();
    }

    @Override
    public ASTNode visitShowComputeNodeInfo(KernelDistSQLStatementParser.ShowComputeNodeInfoContext ctx) {
        return new ShowComputeNodeInfoStatement();
    }

    @Override
    public ASTNode visitShowComputeNodeMode(KernelDistSQLStatementParser.ShowComputeNodeModeContext ctx) {
        return new ShowComputeNodeModeStatement();
    }

    @Override
    public ASTNode visitEnableComputeNode(KernelDistSQLStatementParser.EnableComputeNodeContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.ENABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitDisableComputeNode(KernelDistSQLStatementParser.DisableComputeNodeContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.DISABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitLabelComputeNode(KernelDistSQLStatementParser.LabelComputeNodeContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new LabelComputeNodeStatement(ctx.RELABEL() != null, this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    @Override
    public ASTNode visitUnlabelComputeNode(KernelDistSQLStatementParser.UnlabelComputeNodeContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new UnlabelComputeNodeStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    private SetInstanceStatusStatement buildSetInstanceStatusStatement(String status, KernelDistSQLStatementParser.InstanceIdContext instanceIdContext) {
        return new SetInstanceStatusStatement(status, this.getIdentifierValue((ParseTree)instanceIdContext));
    }

    @Override
    public ASTNode visitCountSingleTableRule(KernelDistSQLStatementParser.CountSingleTableRuleContext ctx) {
        return new CountSingleTableRuleStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitAlterComputeNode(KernelDistSQLStatementParser.AlterComputeNodeContext ctx) {
        return new AlterComputeNodeStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValues()));
    }

    @Override
    public ASTNode visitSetDefaultSingleTableStorageUnit(KernelDistSQLStatementParser.SetDefaultSingleTableStorageUnitContext ctx) {
        return new SetDefaultSingleTableStorageUnitStatement(null == ctx.storageUnitName() ? null : this.getIdentifierValue((ParseTree)ctx.storageUnitName()));
    }

    private Properties getProperties(KernelDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (KernelDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitUnregisterStorageUnit(KernelDistSQLStatementParser.UnregisterStorageUnitContext ctx) {
        boolean ignoreSingleTables = null != ctx.ignoreSingleTables();
        return new UnregisterStorageUnitStatement(ctx.ifExists() != null, (Collection)ctx.storageUnitName().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()), ignoreSingleTables);
    }

    @Override
    public ASTNode visitShowStorageUnits(KernelDistSQLStatementParser.ShowStorageUnitsContext ctx) {
        DatabaseSegment database = null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName());
        Integer usageCount = null == ctx.usageCount() ? null : Integer.valueOf(Integer.parseInt(ctx.usageCount().getText()));
        return new ShowStorageUnitsStatement(database, usageCount);
    }

    @Override
    public ASTNode visitDatabaseName(KernelDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSetDistVariable(KernelDistSQLStatementParser.SetDistVariableContext ctx) {
        return new SetDistVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValue()));
    }

    @Override
    public ASTNode visitShowDefaultSingleTableStorageUnit(KernelDistSQLStatementParser.ShowDefaultSingleTableStorageUnitContext ctx) {
        return new ShowDefaultSingleTableStorageUnitStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowSingleTable(KernelDistSQLStatementParser.ShowSingleTableContext ctx) {
        return new ShowSingleTableStatement(null == ctx.TABLE() ? null : this.getIdentifierValue((ParseTree)ctx.tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowDistVariable(KernelDistSQLStatementParser.ShowDistVariableContext ctx) {
        return new ShowDistVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()).toUpperCase());
    }

    @Override
    public ASTNode visitShowDistVariables(KernelDistSQLStatementParser.ShowDistVariablesContext ctx) {
        return new ShowDistVariablesStatement();
    }

    @Override
    public ASTNode visitClearHint(KernelDistSQLStatementParser.ClearHintContext ctx) {
        return new ClearHintStatement();
    }

    @Override
    public ASTNode visitRefreshDatabaseMetadata(KernelDistSQLStatementParser.RefreshDatabaseMetadataContext ctx) {
        return new RefreshDatabaseMetadataStatement(null == ctx.databaseName() ? null : this.getIdentifierValue((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitRefreshTableMetadata(KernelDistSQLStatementParser.RefreshTableMetadataContext ctx) {
        if (null == ctx.refreshScope()) {
            return new RefreshTableMetadataStatement();
        }
        String storageUnitName = null;
        String schemaName = null;
        String tableName = this.getIdentifierValue((ParseTree)ctx.refreshScope().tableName());
        if (null != ctx.refreshScope().fromSegment()) {
            KernelDistSQLStatementParser.FromSegmentContext fromSegment = ctx.refreshScope().fromSegment();
            storageUnitName = this.getIdentifierValue((ParseTree)fromSegment.storageUnitName());
            schemaName = null == fromSegment.schemaName() ? null : this.getIdentifierValue((ParseTree)fromSegment.schemaName());
        }
        return new RefreshTableMetadataStatement(tableName, storageUnitName, schemaName);
    }

    @Override
    public ASTNode visitExportDatabaseConfiguration(KernelDistSQLStatementParser.ExportDatabaseConfigurationContext ctx) {
        return new ExportDatabaseConfigurationStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitConvertYamlConfiguration(KernelDistSQLStatementParser.ConvertYamlConfigurationContext ctx) {
        return new ConvertYamlConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitShowRulesUsedStorageUnit(KernelDistSQLStatementParser.ShowRulesUsedStorageUnitContext ctx) {
        return new ShowRulesUsedStorageUnitStatement(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitPrepareDistSQL(KernelDistSQLStatementParser.PrepareDistSQLContext ctx) {
        return new PrepareDistSQLStatement();
    }

    @Override
    public ASTNode visitApplyDistSQL(KernelDistSQLStatementParser.ApplyDistSQLContext ctx) {
        return new ApplyDistSQLStatement();
    }

    @Override
    public ASTNode visitDiscardDistSQL(KernelDistSQLStatementParser.DiscardDistSQLContext ctx) {
        return new DiscardDistSQLStatement();
    }

    @Override
    public ASTNode visitImportDatabaseConfiguration(KernelDistSQLStatementParser.ImportDatabaseConfigurationContext ctx) {
        return new ImportDatabaseConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitShowMigrationRule(KernelDistSQLStatementParser.ShowMigrationRuleContext ctx) {
        return new ShowMigrationRuleStatement();
    }

    @Override
    public ASTNode visitAlterMigrationRule(KernelDistSQLStatementParser.AlterMigrationRuleContext ctx) {
        InventoryIncrementalRuleSegment segment = null == ctx.inventoryIncrementalRule() ? null : (InventoryIncrementalRuleSegment)this.visit((ParseTree)ctx.inventoryIncrementalRule());
        return new AlterInventoryIncrementalRuleStatement("MIGRATION", segment);
    }

    @Override
    public ASTNode visitInventoryIncrementalRule(KernelDistSQLStatementParser.InventoryIncrementalRuleContext ctx) {
        InventoryIncrementalRuleSegment result = new InventoryIncrementalRuleSegment();
        if (null != ctx.readDefinition()) {
            result.setReadSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.readDefinition()));
        }
        if (null != ctx.writeDefinition()) {
            result.setWriteSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.writeDefinition()));
        }
        if (null != ctx.streamChannel()) {
            result.setStreamChannel((AlgorithmSegment)this.visit((ParseTree)ctx.streamChannel()));
        }
        return result;
    }

    @Override
    public ASTNode visitReadDefinition(KernelDistSQLStatementParser.ReadDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getShardingSize(ctx.shardingSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    @Override
    public ASTNode visitWriteDefinition(KernelDistSQLStatementParser.WriteDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    private AlgorithmSegment getAlgorithmSegment(KernelDistSQLStatementParser.RateLimiterContext ctx) {
        if (null == ctx) {
            return null;
        }
        return (AlgorithmSegment)this.visit((ParseTree)ctx);
    }

    @Override
    public ASTNode visitAlgorithmDefinition(KernelDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.buildProperties(ctx.propertiesDefinition()));
    }

    private Properties buildProperties(KernelDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx) {
            return result;
        }
        for (KernelDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    private Integer getWorkerThread(KernelDistSQLStatementParser.WorkerThreadContext ctx) {
        if (null == ctx) {
            return null;
        }
        return Integer.parseInt(ctx.intValue().getText());
    }

    private Integer getBatchSize(KernelDistSQLStatementParser.BatchSizeContext ctx) {
        if (null == ctx) {
            return null;
        }
        return Integer.parseInt(ctx.intValue().getText());
    }

    private Integer getShardingSize(KernelDistSQLStatementParser.ShardingSizeContext ctx) {
        if (null == ctx) {
            return null;
        }
        return Integer.parseInt(ctx.intValue().getText());
    }

    @Override
    public ASTNode visitRateLimiter(KernelDistSQLStatementParser.RateLimiterContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitStreamChannel(KernelDistSQLStatementParser.StreamChannelContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }
}

