/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.ingest.record;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;

public final class DataRecord
extends Record {
    private final List<Column> columns;
    private final List<Object> uniqueKeyValue = new LinkedList<Object>();
    private final List<Object> oldUniqueKeyValues = new ArrayList<Object>();
    private String type;
    private String tableName;
    private Long csn;

    public DataRecord(IngestPosition<?> position, int columnCount) {
        super(position);
        this.columns = new ArrayList<Column>(columnCount);
    }

    public void addColumn(Column data) {
        this.columns.add(data);
        if (data.isUniqueKey()) {
            this.uniqueKeyValue.add(data.getValue());
            this.oldUniqueKeyValues.add(data.getOldValue());
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public Key getKey() {
        return new Key(this.tableName, this.uniqueKeyValue);
    }

    public Key getOldKey() {
        return new Key(this.tableName, this.oldUniqueKeyValues);
    }

    @Generated
    public List<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public List<Object> getUniqueKeyValue() {
        return this.uniqueKeyValue;
    }

    @Generated
    public List<Object> getOldUniqueKeyValues() {
        return this.oldUniqueKeyValues;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Long getCsn() {
        return this.csn;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setCsn(Long csn) {
        this.csn = csn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRecord)) {
            return false;
        }
        DataRecord other = (DataRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Object> this$uniqueKeyValue = this.getUniqueKeyValue();
        List<Object> other$uniqueKeyValue = other.getUniqueKeyValue();
        if (this$uniqueKeyValue == null ? other$uniqueKeyValue != null : !((Object)this$uniqueKeyValue).equals(other$uniqueKeyValue)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Object> $uniqueKeyValue = this.getUniqueKeyValue();
        result = result * 59 + ($uniqueKeyValue == null ? 43 : ((Object)$uniqueKeyValue).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataRecord(columns=" + this.getColumns() + ", uniqueKeyValue=" + this.getUniqueKeyValue() + ", oldUniqueKeyValues=" + this.getOldUniqueKeyValues() + ", type=" + this.getType() + ", tableName=" + this.getTableName() + ", csn=" + this.getCsn() + ")";
    }

    public static class Key {
        private final String tableName;
        private final List<Object> uniqueKeyValues;

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableName = this.tableName;
            String other$tableName = other.tableName;
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            List<Object> this$uniqueKeyValues = this.uniqueKeyValues;
            List<Object> other$uniqueKeyValues = other.uniqueKeyValues;
            return !(this$uniqueKeyValues == null ? other$uniqueKeyValues != null : !((Object)this$uniqueKeyValues).equals(other$uniqueKeyValues));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableName = this.tableName;
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            List<Object> $uniqueKeyValues = this.uniqueKeyValues;
            result = result * 59 + ($uniqueKeyValues == null ? 43 : ((Object)$uniqueKeyValues).hashCode());
            return result;
        }

        @Generated
        public Key(String tableName, List<Object> uniqueKeyValues) {
            this.tableName = tableName;
            this.uniqueKeyValues = uniqueKeyValues;
        }
    }
}

